/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.sparql;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.sparql.RDFServiceSparql;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class RDFServiceSparqlHttp
extends RDFServiceSparql {
    public RDFServiceSparqlHttp(String readEndpointURI, String updateEndpointURI) {
        super(readEndpointURI, updateEndpointURI);
    }

    public RDFServiceSparqlHttp(String endpointURI) {
        super(endpointURI);
    }

    public RDFServiceSparqlHttp(String readEndpointURI, String updateEndpointURI, String defaultWriteGraphURI) {
        super(readEndpointURI, updateEndpointURI, defaultWriteGraphURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream sparqlConstructQuery(String queryStr, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        Model model = ModelFactory.createDefaultModel();
        try (QueryEngineHTTP qeh = new QueryEngineHTTP(this.readEndpointURI, queryStr);){
            qeh.execConstruct(model);
        }
        ByteArrayOutputStream serializedModel = new ByteArrayOutputStream();
        model.write((OutputStream)serializedModel, RDFServiceSparqlHttp.getSerializationFormatString(resultFormat));
        ByteArrayInputStream result = new ByteArrayInputStream(serializedModel.toByteArray());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sparqlConstructQuery(String queryStr, Model model) throws RDFServiceException {
        try (QueryEngineHTTP qeh = new QueryEngineHTTP(this.readEndpointURI, queryStr);){
            qeh.execConstruct(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream sparqlDescribeQuery(String queryStr, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        Model model = ModelFactory.createDefaultModel();
        try (QueryEngineHTTP qeh = new QueryEngineHTTP(this.readEndpointURI, queryStr);){
            qeh.execDescribe(model);
        }
        ByteArrayOutputStream serializedModel = new ByteArrayOutputStream();
        model.write((OutputStream)serializedModel, RDFServiceSparqlHttp.getSerializationFormatString(resultFormat));
        ByteArrayInputStream result = new ByteArrayInputStream(serializedModel.toByteArray());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream sparqlSelectQuery(String queryStr, RDFService.ResultFormat resultFormat) throws RDFServiceException {
        try (QueryEngineHTTP qeh = new QueryEngineHTTP(this.readEndpointURI, queryStr);){
            ByteArrayInputStream result;
            ResultSet resultSet = qeh.execSelect();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            switch (resultFormat) {
                case CSV: {
                    ResultSetFormatter.outputAsCSV((OutputStream)outputStream, (ResultSet)resultSet);
                    break;
                }
                case TEXT: {
                    ResultSetFormatter.out((OutputStream)outputStream, (ResultSet)resultSet);
                    break;
                }
                case JSON: {
                    ResultSetFormatter.outputAsJSON((OutputStream)outputStream, (ResultSet)resultSet);
                    break;
                }
                case XML: {
                    ResultSetFormatter.outputAsXML((OutputStream)outputStream, (ResultSet)resultSet);
                    break;
                }
                default: {
                    throw new RDFServiceException("unrecognized result format");
                }
            }
            ByteArrayInputStream byteArrayInputStream = result = new ByteArrayInputStream(outputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sparqlSelectQuery(String queryStr, ResultSetConsumer consumer) throws RDFServiceException {
        try (QueryEngineHTTP qeh = new QueryEngineHTTP(this.readEndpointURI, queryStr);){
            consumer.processResultSet(qeh.execSelect());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sparqlAskQuery(String queryStr) throws RDFServiceException {
        try (QueryEngineHTTP qeh = new QueryEngineHTTP(this.readEndpointURI, queryStr);){
            boolean bl = qeh.execAsk();
            return bl;
        }
    }
}

