/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.reasoner;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DifferenceGraph;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ModelChange;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import edu.cornell.mannlib.vitro.webapp.reasoner.ABoxRecomputer;
import edu.cornell.mannlib.vitro.webapp.reasoner.IndividualURIQueue;
import edu.cornell.mannlib.vitro.webapp.reasoner.ModelUpdate;
import edu.cornell.mannlib.vitro.webapp.reasoner.ReasonerPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleReasoner
extends StatementListener
implements ModelChangedListener,
ChangeListener {
    private static final Log log = LogFactory.getLog(SimpleReasoner.class);
    private final SearchIndexer searchIndexer;
    private OntModel tboxModel;
    private OntModel aboxModel;
    private Model inferenceModel;
    private OntModel fullModel;
    private static final String mostSpecificTypePropertyURI = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType";
    private static final AnnotationProperty mostSpecificType = VitroModelFactory.createOntologyModel().createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType");
    private ABoxRecomputer recomputer = null;
    private List<ReasonerPlugin> pluginList = new CopyOnWriteArrayList<ReasonerPlugin>();
    private boolean doSameAs = true;

    public SimpleReasoner(OntModel tboxModel, RDFService rdfService, Model inferenceModel, Model inferenceRebuildModel, Model scratchpadModel, SearchIndexer searchIndexer) {
        this.searchIndexer = searchIndexer;
        this.tboxModel = tboxModel;
        this.fullModel = VitroModelFactory.createOntologyModel(VitroModelFactory.createModelForGraph((Graph)new RDFServiceGraph(rdfService)));
        this.aboxModel = VitroModelFactory.createOntologyModel(VitroModelFactory.createModelForGraph(new DifferenceGraph(new DifferenceGraph((Graph)new RDFServiceGraph(rdfService), inferenceModel.getGraph()), tboxModel.getGraph())));
        this.inferenceModel = inferenceModel;
        this.recomputer = new ABoxRecomputer(tboxModel, this.aboxModel, rdfService, this, searchIndexer);
        if (rdfService == null) {
            this.aboxModel.register((ModelChangedListener)this);
        } else {
            try {
                rdfService.registerListener(this);
            }
            catch (RDFServiceException e) {
                throw new RuntimeException("Unable to register change listener", e);
            }
        }
    }

    public SimpleReasoner(OntModel tboxModel, OntModel aboxModel, Model inferenceModel) {
        this.searchIndexer = null;
        this.tboxModel = tboxModel;
        this.aboxModel = aboxModel;
        this.inferenceModel = inferenceModel;
        this.fullModel = VitroModelFactory.createUnion(aboxModel, VitroModelFactory.createOntologyModel(inferenceModel));
        Dataset ds = DatasetFactory.createMem();
        ds.addNamedModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-2", (Model)aboxModel);
        ds.addNamedModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf", inferenceModel);
        ds.addNamedModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox", (Model)tboxModel);
        ds.setDefaultModel(ModelFactory.createUnion((Model)this.fullModel, (Model)tboxModel));
        this.recomputer = new ABoxRecomputer(tboxModel, aboxModel, new RDFServiceModel(ds), this, this.searchIndexer);
    }

    public void setPluginList(List<ReasonerPlugin> pluginList) {
        this.pluginList = pluginList;
    }

    public List<ReasonerPlugin> getPluginList() {
        return this.pluginList;
    }

    public void setSameAsEnabled(boolean tf) {
        this.doSameAs = tf;
    }

    public boolean getSameAsEnabled() {
        return this.doSameAs;
    }

    @Override
    public void notifyModelChange(ModelChange modelChange) {
        if (this.isABoxInferenceGraph(modelChange.getGraphURI()) || this.isTBoxGraph(modelChange.getGraphURI())) {
            return;
        }
        IndividualURIQueue<String> individualURIs = new IndividualURIQueue<String>();
        Model m = RDFServiceUtils.parseModel(modelChange.getSerializedModel(), modelChange.getSerializationFormat());
        StmtIterator sit = m.listStatements();
        while (sit.hasNext()) {
            this.queueRelevantIndividuals(sit.nextStatement(), individualURIs);
        }
        this.recomputeIndividuals(individualURIs);
    }

    public void addedStatement(Statement stmt) {
        this.doPlugins(ModelUpdate.Operation.ADD, stmt);
        this.listenToStatement(stmt, new IndividualURIQueue<String>());
    }

    public void removedStatement(Statement stmt) {
        this.doPlugins(ModelUpdate.Operation.RETRACT, stmt);
        IndividualURIQueue<String> individualURIs = new IndividualURIQueue<String>();
        if (this.doSameAs && OWL.sameAs.equals(stmt.getPredicate())) {
            if (stmt.getSubject().isURIResource()) {
                individualURIs.addAll(this.recomputer.getSameAsIndividuals(stmt.getSubject().getURI()));
            }
            if (stmt.getObject().isURIResource()) {
                individualURIs.addAll(this.recomputer.getSameAsIndividuals(stmt.getObject().asResource().getURI()));
            }
        }
        this.listenToStatement(stmt, individualURIs);
    }

    private void listenToStatement(Statement stmt, Queue<String> individualURIs) {
        this.queueRelevantIndividuals(stmt, individualURIs);
        this.recomputeIndividuals(individualURIs);
    }

    private void queueRelevantIndividuals(Statement stmt, Queue<String> individualURIs) {
        if (stmt.getSubject().isURIResource()) {
            individualURIs.add(stmt.getSubject().getURI());
        }
        if (stmt.getObject().isURIResource() && !RDF.type.equals(stmt.getPredicate())) {
            individualURIs.add(stmt.getObject().asResource().getURI());
        }
    }

    private void recomputeIndividuals(Queue<String> individualURIs) {
        long start = System.currentTimeMillis();
        int size = individualURIs.size();
        this.recomputer.recompute(individualURIs);
        if (size > 2) {
            log.info((Object)(System.currentTimeMillis() - start + " ms to recompute " + size + " individuals"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changedTBoxStatement(Statement stmt, boolean add) {
        block25: {
            try {
                if (!(stmt.getPredicate().equals(RDFS.subClassOf) || stmt.getPredicate().equals(OWL.equivalentClass) || stmt.getPredicate().equals(OWL.inverseOf))) {
                    return;
                }
                if (!stmt.getObject().isResource()) {
                    log.warn((Object)("The object of this assertion is not a resource: " + SimpleReasoner.stmtString(stmt)));
                    return;
                }
                if (stmt.getPredicate().equals(RDFS.subClassOf) || stmt.getPredicate().equals(OWL.equivalentClass)) {
                    OntClass object;
                    OntClass subject;
                    if (stmt.getSubject().isAnon() || stmt.getObject().isAnon()) {
                        return;
                    }
                    this.tboxModel.enterCriticalSection(true);
                    try {
                        subject = this.tboxModel.getOntClass(stmt.getSubject().getURI());
                        if (subject == null) {
                            log.debug((Object)("didn't find subject class in the tbox: " + stmt.getSubject().getURI()));
                            return;
                        }
                        object = this.tboxModel.getOntClass(((Resource)stmt.getObject()).getURI());
                        if (object == null) {
                            log.debug((Object)("didn't find object class in the tbox: " + ((Resource)stmt.getObject()).getURI()));
                            return;
                        }
                    }
                    finally {
                        this.tboxModel.leaveCriticalSection();
                    }
                    if (stmt.getPredicate().equals(RDFS.subClassOf)) {
                        if (add) {
                            this.addedSubClass(subject, object, this.inferenceModel);
                        } else {
                            this.removedSubClass(subject, object, this.inferenceModel);
                        }
                    } else if (add) {
                        this.addedSubClass(subject, object, this.inferenceModel);
                        this.addedSubClass(object, subject, this.inferenceModel);
                    } else {
                        this.removedSubClass(subject, object, this.inferenceModel);
                        this.removedSubClass(object, subject, this.inferenceModel);
                    }
                    break block25;
                }
                if (stmt.getObject().asResource().getURI() == null) {
                    log.warn((Object)("The object of this assertion has a null URI: " + SimpleReasoner.stmtString(stmt)));
                    return;
                }
                if (stmt.getSubject().getURI() == null) {
                    log.warn((Object)("The subject of this assertion has a null URI: " + SimpleReasoner.stmtString(stmt)));
                    return;
                }
                OntProperty prop1 = this.tboxModel.getOntProperty(stmt.getSubject().getURI());
                if (prop1 == null) {
                    log.debug((Object)("didn't find subject property in the tbox: " + stmt.getSubject().getURI()));
                    return;
                }
                OntProperty prop2 = this.tboxModel.getOntProperty(((Resource)stmt.getObject()).getURI());
                if (prop2 == null) {
                    log.debug((Object)("didn't find object property in the tbox: " + ((Resource)stmt.getObject()).getURI()));
                    return;
                }
                if (add) {
                    this.addedInverseProperty(prop1, prop2, this.inferenceModel);
                } else {
                    this.removedInverseProperty(prop1, prop2, this.inferenceModel);
                }
            }
            catch (Exception e) {
                log.error((Object)("Exception while " + (add ? "adding" : "removing") + " inference(s)"), (Throwable)e);
            }
        }
    }

    public void addedTBoxStatement(Statement stmt) {
        this.changedTBoxStatement(stmt, true);
    }

    public void removedTBoxStatement(Statement stmt) {
        this.changedTBoxStatement(stmt, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addedSubClass(OntClass subClass, OntClass superClass, Model inferenceModel) {
        OntModel unionModel = VitroModelFactory.createOntologyModel();
        unionModel.addSubModel((Model)this.aboxModel);
        unionModel.addSubModel(inferenceModel);
        ArrayList<Resource> subjectList = new ArrayList<Resource>();
        this.aboxModel.enterCriticalSection(true);
        try {
            StmtIterator iter = unionModel.listStatements((Resource)null, RDF.type, (RDFNode)subClass);
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                subjectList.add(stmt.getSubject());
            }
        }
        finally {
            this.aboxModel.leaveCriticalSection();
        }
        for (Resource subject : subjectList) {
            Statement infStmt = ResourceFactory.createStatement((Resource)subject, (Property)RDF.type, (RDFNode)superClass);
            this.addInference(infStmt, inferenceModel, true);
            this.setMostSpecificTypes(infStmt.getSubject(), inferenceModel, new HashSet<String>());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removedSubClass(OntClass subClass, OntClass superClass, Model inferenceModel) {
        OntModel unionModel = VitroModelFactory.createOntologyModel();
        unionModel.addSubModel((Model)this.aboxModel);
        unionModel.addSubModel(inferenceModel);
        ArrayList<Resource> subjectList = new ArrayList<Resource>();
        this.aboxModel.enterCriticalSection(true);
        try {
            StmtIterator iter = unionModel.listStatements((Resource)null, RDF.type, (RDFNode)subClass);
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                subjectList.add(stmt.getSubject());
            }
        }
        finally {
            this.aboxModel.leaveCriticalSection();
        }
        for (Resource ind : subjectList) {
            if (this.entailedType(ind, (Resource)superClass)) continue;
            Statement infStmt = ResourceFactory.createStatement((Resource)ind, (Property)RDF.type, (RDFNode)superClass);
            inferenceModel.enterCriticalSection(false);
            try {
                if (inferenceModel.contains(infStmt)) {
                    inferenceModel.remove(infStmt);
                }
            }
            finally {
                inferenceModel.leaveCriticalSection();
            }
            this.setMostSpecificTypes(ind, inferenceModel, new HashSet<String>());
        }
    }

    protected void addedInverseProperty(OntProperty prop1, OntProperty prop2, Model inferenceModel) {
        if (!prop1.isObjectProperty() || !prop2.isObjectProperty()) {
            log.warn((Object)("The subject and object of the inverseOf statement are not both object properties. No inferencing will be performed. property 1: " + prop1.getURI() + " property 2:" + prop2.getURI()));
            return;
        }
        Model inferences = ModelFactory.createDefaultModel();
        inferences.add(this.generateInverseInferences(prop1, prop2));
        inferences.add(this.generateInverseInferences(prop2, prop1));
        if (inferences.isEmpty()) {
            return;
        }
        StmtIterator iter = inferences.listStatements();
        while (iter.hasNext()) {
            Statement infStmt = (Statement)iter.next();
            this.addInference(infStmt, inferenceModel, true);
        }
    }

    protected void removedInverseProperty(OntProperty prop1, OntProperty prop2, Model inferenceModel) {
        if (!prop1.isObjectProperty() || !prop2.isObjectProperty()) {
            log.warn((Object)("The subject and object of the inverseOf statement are not both object properties. No inferencing will be performed. property 1: " + prop1.getURI() + " property 2:" + prop2.getURI()));
            return;
        }
        Model inferences = ModelFactory.createDefaultModel();
        inferences.add(this.generateInverseInferences(prop1, prop2));
        inferences.add(this.generateInverseInferences(prop2, prop1));
        if (inferences.isEmpty()) {
            return;
        }
        StmtIterator iter = inferences.listStatements();
        while (iter.hasNext()) {
            Statement infStmt = (Statement)iter.next();
            if (this.entailedStatement(infStmt)) continue;
            this.removeInference(infStmt, inferenceModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Resource> getSameIndividuals(Resource ind, Model inferenceModel) {
        ArrayList<Resource> sameIndividuals = new ArrayList<Resource>();
        this.fullModel.enterCriticalSection(true);
        try {
            StmtIterator iter = this.fullModel.listStatements(ind, OWL.sameAs, (RDFNode)null);
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                if (stmt.getObject() == null || !stmt.getObject().isResource() || stmt.getObject().asResource().getURI() == null) continue;
                sameIndividuals.add(stmt.getObject().asResource());
            }
        }
        finally {
            this.fullModel.leaveCriticalSection();
        }
        return sameIndividuals;
    }

    protected boolean entailedType(Resource subject, Resource cls) {
        return this.entailedType(subject, cls, null);
    }

    protected boolean entailedType(Resource subject, Resource cls, List<String> remainingTypeURIs) {
        List<Resource> subClasses = this.getSubClasses(cls);
        HashSet<String> subClassURIs = new HashSet<String>();
        for (Resource subClass : subClasses) {
            if (subClass.isAnon()) continue;
            subClassURIs.add(subClass.getURI());
        }
        List<String> typeURIs = remainingTypeURIs == null ? this.getRemainingAssertedTypeURIs(subject) : remainingTypeURIs;
        for (String typeURI : typeURIs) {
            if (typeURI.equals(cls.getURI()) || !subClassURIs.contains(typeURI)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getRemainingAssertedTypeURIs(Resource resource) {
        ArrayList<String> typeURIs = new ArrayList<String>();
        List<Resource> sameIndividuals = this.getSameIndividuals(resource, this.inferenceModel);
        sameIndividuals.add(resource);
        this.aboxModel.enterCriticalSection(true);
        try {
            for (Resource res : sameIndividuals) {
                StmtIterator typeIt = this.aboxModel.listStatements(res, RDF.type, (RDFNode)null);
                while (typeIt.hasNext()) {
                    Statement stmt = typeIt.nextStatement();
                    if (!stmt.getObject().isURIResource()) continue;
                    String typeURI = stmt.getObject().asResource().getURI();
                    typeURIs.add(typeURI);
                }
            }
        }
        finally {
            this.aboxModel.leaveCriticalSection();
        }
        return typeURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Resource> getSubClasses(Resource cls) {
        ArrayList<Resource> subClasses = new ArrayList<Resource>();
        this.tboxModel.enterCriticalSection(true);
        try {
            Statement stmt;
            StmtIterator iter = this.tboxModel.listStatements((Resource)null, RDFS.subClassOf, (RDFNode)cls);
            while (iter.hasNext()) {
                stmt = (Statement)iter.next();
                if (stmt.getSubject() == null || stmt.getSubject().asResource().getURI() == null || subClasses.contains(stmt.getSubject())) continue;
                subClasses.add(stmt.getSubject());
            }
            iter = this.tboxModel.listStatements((Resource)null, OWL.equivalentClass, (RDFNode)cls);
            while (iter.hasNext()) {
                stmt = (Statement)iter.next();
                if (stmt.getSubject() == null || stmt.getSubject().getURI() == null || subClasses.contains(stmt.getSubject())) continue;
                subClasses.add(stmt.getSubject());
            }
            ArrayList<Resource> arrayList = subClasses;
            return arrayList;
        }
        finally {
            this.tboxModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Resource> getSuperClasses(Resource cls) {
        ArrayList<Resource> superClasses = new ArrayList<Resource>();
        this.tboxModel.enterCriticalSection(true);
        try {
            Statement stmt;
            StmtIterator iter = this.tboxModel.listStatements(cls, RDFS.subClassOf, (RDFNode)null);
            while (iter.hasNext()) {
                Resource superCls;
                stmt = (Statement)iter.next();
                if (stmt.getObject() == null || !stmt.getObject().isResource() || (superCls = stmt.getObject().asResource()).isAnon() || superClasses.contains(superCls)) continue;
                superClasses.add(superCls);
            }
            iter = this.tboxModel.listStatements((Resource)null, OWL.equivalentClass, (RDFNode)cls);
            while (iter.hasNext()) {
                stmt = (Statement)iter.next();
                if (stmt.getSubject() == null || stmt.getSubject().asResource().getURI() == null || superClasses.contains(stmt.getSubject())) continue;
                superClasses.add(stmt.getSubject());
            }
            ArrayList<Resource> arrayList = superClasses;
            return arrayList;
        }
        finally {
            this.tboxModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean entailedStatement(Statement stmt) {
        List<Resource> sameIndividuals;
        Iterator<Resource> rIter;
        List<OntProperty> inverses = this.getInverseProperties(stmt);
        Iterator<OntProperty> iIter = inverses.iterator();
        if (iIter.hasNext()) {
            this.aboxModel.enterCriticalSection(true);
            try {
                while (iIter.hasNext()) {
                    Property invProp = (Property)iIter.next();
                    Statement invStmt = ResourceFactory.createStatement((Resource)stmt.getObject().asResource(), (Property)invProp, (RDFNode)stmt.getSubject());
                    if (!this.aboxModel.contains(invStmt)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.aboxModel.leaveCriticalSection();
            }
        }
        if (this.doSameAs && (rIter = (sameIndividuals = this.getSameIndividuals(stmt.getSubject().asResource(), this.inferenceModel)).iterator()).hasNext()) {
            this.aboxModel.enterCriticalSection(true);
            try {
                while (rIter.hasNext()) {
                    Resource subject = rIter.next();
                    if (!this.aboxModel.contains(subject, stmt.getPredicate(), stmt.getObject())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.aboxModel.leaveCriticalSection();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<OntProperty> getInverseProperties(Statement stmt) {
        ArrayList<OntProperty> inverses = new ArrayList<OntProperty>();
        if (stmt.getSubject().isAnon() || stmt.getObject().isAnon()) {
            return inverses;
        }
        this.tboxModel.enterCriticalSection(true);
        try {
            OntProperty prop = this.tboxModel.getOntProperty(stmt.getPredicate().getURI());
            if (prop != null) {
                if (!prop.isObjectProperty()) {
                    ArrayList<OntProperty> arrayList = inverses;
                    return arrayList;
                }
                if (!stmt.getObject().isResource()) {
                    log.debug((Object)"The predicate of this statement is an object property, but the object is not a resource.");
                    ArrayList<OntProperty> arrayList = inverses;
                    return arrayList;
                }
                if (prop.getNameSpace().equals("http://www.w3.org/2002/07/owl#") || prop.getNameSpace().equals(RDFS.getURI()) || prop.getNameSpace().equals(RDF.getURI())) {
                    ArrayList<OntProperty> arrayList = inverses;
                    return arrayList;
                }
                ExtendedIterator iter = prop.listInverse();
                while (iter.hasNext()) {
                    OntProperty invProp = (OntProperty)iter.next();
                    if (invProp.getNameSpace().equals("http://www.w3.org/2002/07/owl#") || invProp.getNameSpace().equals(RDFS.getURI()) || invProp.getNameSpace().equals(RDF.getURI())) continue;
                    inverses.add(invProp);
                }
            }
        }
        finally {
            this.tboxModel.leaveCriticalSection();
        }
        return inverses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Model generateInverseInferences(OntProperty prop, OntProperty inverseProp) {
        Model inferences = ModelFactory.createDefaultModel();
        this.aboxModel.enterCriticalSection(true);
        try {
            StmtIterator iter = this.aboxModel.listStatements((Resource)null, (Property)prop, (RDFNode)null);
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                if (!stmt.getObject().isResource()) continue;
                Statement infStmt = ResourceFactory.createStatement((Resource)stmt.getObject().asResource(), (Property)inverseProp, (RDFNode)stmt.getSubject());
                inferences.add(infStmt);
            }
        }
        finally {
            this.aboxModel.leaveCriticalSection();
        }
        return inferences;
    }

    public void addInference(Statement infStmt, Model inferenceModel) {
        this.addInference(infStmt, inferenceModel, true);
    }

    protected void addInference(Statement infStmt, Model inferenceModel, boolean handleSameAs) {
        this.addInference(infStmt, inferenceModel, handleSameAs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInference(Statement infStmt, Model inferenceModel, boolean handleSameAs, boolean checkRedundancy) {
        this.aboxModel.enterCriticalSection(true);
        try {
            inferenceModel.enterCriticalSection(false);
            try {
                if (!checkRedundancy || !inferenceModel.contains(infStmt) && !this.aboxModel.contains(infStmt)) {
                    inferenceModel.add(infStmt);
                }
                if (handleSameAs) {
                    List<Resource> sameIndividuals = this.getSameIndividuals(infStmt.getSubject().asResource(), inferenceModel);
                    for (Resource subject : sameIndividuals) {
                        Statement sameStmt = ResourceFactory.createStatement((Resource)subject, (Property)infStmt.getPredicate(), (RDFNode)infStmt.getObject());
                        if (subject.equals((Object)infStmt.getObject()) && OWL.sameAs.equals(infStmt.getPredicate()) || inferenceModel.contains(sameStmt) || this.aboxModel.contains(sameStmt)) continue;
                        inferenceModel.add(sameStmt);
                    }
                }
            }
            finally {
                inferenceModel.leaveCriticalSection();
            }
        }
        finally {
            this.aboxModel.leaveCriticalSection();
        }
    }

    public void removeInference(Statement infStmt, Model inferenceModel) {
        this.removeInference(infStmt, inferenceModel, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInference(Statement infStmt, Model inferenceModel, boolean handleSameAs, boolean checkEntailment) {
        inferenceModel.enterCriticalSection(false);
        try {
            if (!(checkEntailment && this.entailedStatement(infStmt) || !inferenceModel.contains(infStmt))) {
                inferenceModel.remove(infStmt);
            }
        }
        finally {
            inferenceModel.leaveCriticalSection();
        }
        if (handleSameAs) {
            inferenceModel.enterCriticalSection(false);
            try {
                List<Resource> sameIndividuals = this.getSameIndividuals(infStmt.getSubject().asResource(), inferenceModel);
                Iterator<Resource> sameIter = sameIndividuals.iterator();
                while (sameIter.hasNext()) {
                    Statement infStmtSame = ResourceFactory.createStatement((Resource)sameIter.next(), (Property)infStmt.getPredicate(), (RDFNode)infStmt.getObject());
                    if (checkEntailment && this.entailedStatement(infStmtSame) || !inferenceModel.contains(infStmtSame)) continue;
                    inferenceModel.remove(infStmtSame);
                }
            }
            finally {
                inferenceModel.leaveCriticalSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMostSpecificTypes(Resource individual, Model inferenceModel, HashSet<String> unknownTypes) {
        this.tboxModel.enterCriticalSection(true);
        this.aboxModel.enterCriticalSection(true);
        inferenceModel.enterCriticalSection(true);
        HashSet<String> typeURIs = new HashSet<String>();
        try {
            OntModel unionModel = VitroModelFactory.createOntologyModel();
            unionModel.addSubModel((Model)this.aboxModel);
            unionModel.addSubModel(inferenceModel);
            ArrayList<OntClass> types = new ArrayList<OntClass>();
            StmtIterator stmtIter = unionModel.listStatements(individual, RDF.type, (RDFNode)null);
            while (stmtIter.hasNext()) {
                Statement stmt = (Statement)stmtIter.next();
                if (!stmt.getObject().isResource()) {
                    log.warn((Object)("The object of this rdf:type assertion is expected to be a resource: " + SimpleReasoner.stmtString(stmt)));
                    continue;
                }
                OntClass ontClass = null;
                if (stmt.getObject().asResource().getURI() == null) {
                    log.debug((Object)("The object of this rdf:type assertion has a null URI: " + SimpleReasoner.stmtString(stmt)));
                    continue;
                }
                ontClass = this.tboxModel.getOntClass(stmt.getObject().asResource().getURI());
                if (ontClass == null) {
                    if (stmt.getObject().asResource().getNameSpace().equals("http://www.w3.org/2002/07/owl#") || unknownTypes.contains(stmt.getObject().asResource().getURI())) continue;
                    unknownTypes.add(stmt.getObject().asResource().getURI());
                    log.debug((Object)("Didn't find the target class (the object of an asserted or inferred rdf:type statement) in the TBox: " + stmt.getObject().asResource().getURI() + ". No mostSpecificType computation will be done based on " + stmt.getObject().asResource().getURI() + " type statements."));
                    continue;
                }
                if (ontClass.isAnon()) continue;
                types.add(ontClass);
            }
            ArrayList<OntClass> types2 = new ArrayList<OntClass>();
            types2.addAll(types);
            for (OntClass type : types) {
                boolean add = true;
                for (OntClass type2 : types2) {
                    if (type.equals(type2) || !type.hasSubClass((Resource)type2, false) || type2.hasSubClass((Resource)type, false)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                typeURIs.add(type.getURI());
                ArrayList<Resource> equivalentClasses = new ArrayList<Resource>();
                StmtIterator iter = this.tboxModel.listStatements((Resource)null, OWL.equivalentClass, (RDFNode)type);
                while (iter.hasNext()) {
                    Statement stmt = (Statement)iter.next();
                    Resource res = stmt.getSubject();
                    if (res == null || res.isAnon() || equivalentClasses.contains(res)) continue;
                    equivalentClasses.add(res);
                }
                for (Resource equivClass : equivalentClasses) {
                    if (equivClass.isAnon()) continue;
                    typeURIs.add(equivClass.getURI());
                }
            }
        }
        finally {
            inferenceModel.leaveCriticalSection();
            this.aboxModel.leaveCriticalSection();
            this.tboxModel.leaveCriticalSection();
        }
        this.setMostSpecificTypes(individual, typeURIs, inferenceModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMostSpecificTypes(Resource individual, HashSet<String> typeURIs, Model inferenceModel) {
        Model retractions = ModelFactory.createDefaultModel();
        inferenceModel.enterCriticalSection(true);
        try {
            StmtIterator iter = inferenceModel.listStatements(individual, (Property)mostSpecificType, (RDFNode)null);
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                if (!stmt.getObject().isResource()) {
                    log.warn((Object)("The object of this assertion is expected to be a resource: " + SimpleReasoner.stmtString(stmt)));
                    continue;
                }
                if (typeURIs.contains(stmt.getObject().asResource().getURI())) continue;
                retractions.add(stmt);
            }
        }
        finally {
            inferenceModel.leaveCriticalSection();
        }
        StmtIterator rIter = retractions.listStatements();
        while (rIter.hasNext()) {
            this.removeInference((Statement)rIter.next(), inferenceModel, true, false);
        }
        for (String typeURI : typeURIs) {
            Statement mstStmt = ResourceFactory.createStatement((Resource)individual, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)typeURI));
            this.addInference(mstStmt, inferenceModel, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Resource> getParents(Resource cls, OntModel tboxModel) {
        ArrayList<Resource> parents = new ArrayList<Resource>();
        tboxModel.enterCriticalSection(true);
        try {
            Statement stmt;
            StmtIterator iter = tboxModel.listStatements(cls, RDFS.subClassOf, (RDFNode)null);
            while (iter.hasNext()) {
                stmt = (Statement)iter.next();
                if (stmt.getObject() == null || !stmt.getObject().isResource() || stmt.getObject().asResource().isAnon() || parents.contains(stmt.getObject().asResource())) continue;
                parents.add(stmt.getObject().asResource());
            }
            iter = tboxModel.listStatements(cls, OWL.equivalentClass, (RDFNode)null);
            while (iter.hasNext()) {
                stmt = (Statement)iter.next();
                if (stmt.getObject() == null || !stmt.getObject().isResource() || stmt.getObject().asResource().isAnon() || parents.contains(stmt.getObject().asResource())) continue;
                parents.add(stmt.getObject().asResource());
            }
        }
        catch (Exception e) {
            log.error((Object)("problem computing type inferences for: " + cls.getURI() + e.getMessage()));
        }
        finally {
            tboxModel.leaveCriticalSection();
        }
        return parents;
    }

    protected boolean isInterestedInRemovedStatement(Statement stmt) {
        if (stmt.getPredicate().equals(RDF.type)) {
            return true;
        }
        for (ReasonerPlugin plugin : this.getPluginList()) {
            if (!plugin.isInterestedInRemovedStatement(stmt)) continue;
            return true;
        }
        return false;
    }

    protected void doPlugins(ModelUpdate.Operation op, Statement stmt) {
        for (ReasonerPlugin plugin : this.getPluginList()) {
            try {
                switch (op) {
                    case ADD: {
                        if (!plugin.isInterestedInAddedStatement(stmt)) break;
                        plugin.addedABoxStatement(stmt, (Model)this.aboxModel, this.inferenceModel, this.tboxModel);
                        break;
                    }
                    case RETRACT: {
                        if (!plugin.isInterestedInRemovedStatement(stmt)) break;
                        plugin.removedABoxStatement(stmt, (Model)this.aboxModel, this.inferenceModel, this.tboxModel);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Exception while processing " + (op == ModelUpdate.Operation.ADD ? "an added" : "a removed") + " statement in SimpleReasoner plugin:" + plugin.getClass().getName() + " -- "), (Throwable)e);
            }
        }
    }

    public boolean isRecomputing() {
        if (this.recomputer == null) {
            return false;
        }
        return this.recomputer.isRecomputing();
    }

    public void recompute() {
        if (this.recomputer != null) {
            this.recomputer.recompute();
        }
    }

    public void setStopRequested() {
        if (this.recomputer != null) {
            this.recomputer.setStopRequested();
        }
    }

    public boolean isABoxReasoningAsynchronous() {
        return false;
    }

    boolean isABoxInferenceGraph(String graphURI) {
        return "http://vitro.mannlib.cornell.edu/default/vitro-kb-inf".equals(graphURI);
    }

    boolean isTBoxGraph(String graphURI) {
        return "http://vitro.mannlib.cornell.edu/default/asserted-tbox".equals(graphURI) || "http://vitro.mannlib.cornell.edu/default/inferred-tbox".equals(graphURI) || graphURI != null && graphURI.contains("tbox");
    }

    @Override
    public void notifyEvent(String string, Object event) {
    }

    public void notifyEvent(Model model, Object event) {
    }

    public static String stmtString(Statement statement) {
        return " [subject = " + statement.getSubject().getURI() + "] [property = " + statement.getPredicate().getURI() + "] [object = " + (statement.getObject().isLiteral() ? ((Literal)statement.getObject()).getLexicalForm() + " (Literal)" : ((Resource)statement.getObject()).getURI() + " (Resource)") + "]";
    }
}

