/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.searchengine.InstrumentedSearchEngineWrapper;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import edu.cornell.mannlib.vitro.webapp.utils.developer.loggers.StackTraceUtility;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.Formatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SearchEngineLogger
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(SearchEngineLogger.class);
    private final long startTime = System.currentTimeMillis();

    public static SearchEngineLogger doAdd(SearchInputDocument[] docs) {
        if (SearchEngineLogger.isEnabled(Key.SEARCH_INDEX_ENABLE)) {
            return new AddLogger(Arrays.asList(docs));
        }
        return new DisabledLogger();
    }

    public static SearchEngineLogger doAdd(Collection<SearchInputDocument> docs) {
        if (SearchEngineLogger.isEnabled(Key.SEARCH_INDEX_ENABLE)) {
            return new AddLogger(docs);
        }
        return new DisabledLogger();
    }

    public static SearchEngineLogger doDeleteById(String[] ids) {
        if (SearchEngineLogger.isEnabled(Key.SEARCH_DELETIONS_ENABLE)) {
            return new DeleteIdsLogger(Arrays.asList(ids));
        }
        return new DisabledLogger();
    }

    public static SearchEngineLogger doDeleteById(Collection<String> ids) {
        if (SearchEngineLogger.isEnabled(Key.SEARCH_DELETIONS_ENABLE)) {
            return new DeleteIdsLogger(ids);
        }
        return new DisabledLogger();
    }

    public static SearchEngineLogger doDeleteByQuery(String query) {
        if (SearchEngineLogger.isEnabled(Key.SEARCH_DELETIONS_ENABLE)) {
            return new DeleteQueryLogger(query);
        }
        return new DisabledLogger();
    }

    public static SearchEngineLogger doQuery(SearchQuery query) {
        if (SearchEngineLogger.isEnabled(Key.SEARCH_ENGINE_ENABLE)) {
            return new QueryLogger(query);
        }
        return new DisabledLogger();
    }

    public static SearchEngineLogger doCountQuery() {
        if (SearchEngineLogger.isEnabled(Key.SEARCH_ENGINE_ENABLE)) {
            return new CountQueryLogger();
        }
        return new DisabledLogger();
    }

    private static boolean isEnabled(Key enableKey) {
        return log.isInfoEnabled() && DeveloperSettings.getInstance().getBoolean(enableKey);
    }

    protected float elapsedSeconds() {
        long endTime = System.currentTimeMillis();
        return (float)(endTime - this.startTime) / 1000.0f;
    }

    @Override
    public void close() {
        try {
            this.writeToLog();
        }
        catch (Exception e) {
            log.error((Object)"Failed to write log record", (Throwable)e);
        }
    }

    public void setSearchResponse(SearchResponse response) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support setSearchResponse()");
    }

    protected abstract void writeToLog();

    private static class DisabledLogger
    extends SearchEngineLogger {
        private DisabledLogger() {
        }

        @Override
        public void setSearchResponse(SearchResponse response) {
        }

        @Override
        protected void writeToLog() {
        }
    }

    public static class CountQueryLogger
    extends SearchEngineLogger {
        private final StackTraceUtility stackTrace = new StackTraceUtility(InstrumentedSearchEngineWrapper.class, true);
        private final boolean passesRestrictions = this.passesQueryRestriction() && this.passesStackRestriction();
        private long count;

        CountQueryLogger() {
            log.debug((Object)("CountQueryLogger: passes=" + this.passesRestrictions));
        }

        private boolean passesStackRestriction() {
            return this.stackTrace.passesStackRestriction(DeveloperSettings.getInstance().getString(Key.SEARCH_ENGINE_STACK_RESTRICTION));
        }

        private boolean passesQueryRestriction() {
            String restriction = DeveloperSettings.getInstance().getString(Key.SEARCH_ENGINE_QUERY_RESTRICTION);
            return StringUtils.isEmpty((String)restriction);
        }

        @Override
        public void setSearchResponse(SearchResponse response) {
            this.count = response.getResults().getNumFound();
        }

        @Override
        public void writeToLog() {
            if (!this.passesRestrictions) {
                return;
            }
            String results = "Document count query found " + this.count + " documents.\n";
            String trace = this.stackTrace.format(this.showStackTrace());
            log.info((Object)String.format("%8.3f %s%s", Float.valueOf(this.elapsedSeconds()), results, trace));
        }

        private boolean showStackTrace() {
            return DeveloperSettings.getInstance().getBoolean(Key.SEARCH_ENGINE_ADD_STACK_TRACE);
        }
    }

    public static class QueryLogger
    extends SearchEngineLogger {
        private final SearchQuery query;
        private final StackTraceUtility stackTrace;
        private final boolean passesRestrictions;
        private SearchResponse response;

        QueryLogger(SearchQuery query) {
            this.query = query;
            this.stackTrace = new StackTraceUtility(InstrumentedSearchEngineWrapper.class, true);
            this.passesRestrictions = this.passesQueryRestriction() && this.passesStackRestriction();
            log.debug((Object)("QueryLogger: query=" + query + ", passes=" + this.passesRestrictions));
        }

        private boolean passesStackRestriction() {
            return this.stackTrace.passesStackRestriction(DeveloperSettings.getInstance().getString(Key.SEARCH_ENGINE_STACK_RESTRICTION));
        }

        private boolean passesQueryRestriction() {
            String restriction = DeveloperSettings.getInstance().getString(Key.SEARCH_ENGINE_QUERY_RESTRICTION);
            if (StringUtils.isEmpty((String)restriction)) {
                return true;
            }
            try {
                return Pattern.matches(restriction, Formatter.format(this.query));
            }
            catch (Exception e) {
                log.warn((Object)("Failed to test query restriction: '" + restriction + "'"), (Throwable)e);
                return true;
            }
        }

        @Override
        public void setSearchResponse(SearchResponse response) {
            this.response = response;
        }

        @Override
        public void writeToLog() {
            if (!this.passesRestrictions) {
                return;
            }
            String results = this.showSearchResults() ? Formatter.format(this.response) : "   returned " + this.response.getResults().size() + " results.\n";
            String trace = this.stackTrace.format(this.showStackTrace());
            log.info((Object)String.format("%8.3f %s%s%s", Float.valueOf(this.elapsedSeconds()), Formatter.format(this.query), results, trace));
        }

        private boolean showSearchResults() {
            return DeveloperSettings.getInstance().getBoolean(Key.SEARCH_ENGINE_ADD_RESULTS);
        }

        private boolean showStackTrace() {
            return DeveloperSettings.getInstance().getBoolean(Key.SEARCH_ENGINE_ADD_STACK_TRACE);
        }
    }

    private static class DeleteQueryLogger
    extends SearchEngineLogger {
        private final String query;

        DeleteQueryLogger(String query) {
            this.query = query;
        }

        @Override
        public void writeToLog() {
            log.info((Object)String.format("%8.3f delete documents as found by this query: %s\n", Float.valueOf(this.elapsedSeconds()), this.query));
        }
    }

    private static class DeleteIdsLogger
    extends SearchEngineLogger {
        private final List<String> ids;

        DeleteIdsLogger(Collection<String> ids) {
            this.ids = new ArrayList<String>(ids);
        }

        @Override
        public void writeToLog() {
            log.info((Object)String.format("%8.3f deleted these %d search documents: %s", Float.valueOf(this.elapsedSeconds()), this.ids.size(), StringUtils.join(this.ids, (String)", ")));
        }
    }

    private static class AddLogger
    extends SearchEngineLogger {
        private final List<SearchInputDocument> docs;
        private final boolean passesRestrictions;

        AddLogger(Collection<SearchInputDocument> docs) {
            this.docs = this.restrictDocsByUriOrName(docs);
            this.passesRestrictions = this.passesDocumentRestriction() && this.docs.size() > 0;
        }

        private List<SearchInputDocument> restrictDocsByUriOrName(Collection<SearchInputDocument> rawDocs) {
            String restriction = DeveloperSettings.getInstance().getString(Key.SEARCH_INDEX_URI_OR_NAME_RESTRICTION);
            if (restriction.isEmpty()) {
                return new ArrayList<SearchInputDocument>(rawDocs);
            }
            ArrayList<SearchInputDocument> list = new ArrayList<SearchInputDocument>();
            for (SearchInputDocument doc : rawDocs) {
                if (!this.passesUriOrNameRestriction(doc, restriction)) continue;
                list.add(doc);
            }
            return list;
        }

        private boolean passesUriOrNameRestriction(SearchInputDocument doc, String restriction) {
            try {
                return Pattern.matches(restriction, Formatter.format(doc));
            }
            catch (Exception e) {
                log.warn((Object)("Failed to test URI or Name restriction: '" + restriction + "'"), (Throwable)e);
                return true;
            }
        }

        private boolean passesDocumentRestriction() {
            String restriction = DeveloperSettings.getInstance().getString(Key.SEARCH_INDEX_DOCUMENT_RESTRICTION);
            if (!restriction.isEmpty()) {
                try {
                    return Pattern.matches(restriction, this.docContents());
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to test document restriction: '" + restriction + "'"), (Throwable)e);
                }
            }
            return true;
        }

        @Override
        public void writeToLog() {
            if (!this.passesRestrictions) {
                return;
            }
            if (this.showDocumentContents()) {
                log.info((Object)String.format("%8.3f added %d documents: \n%s", Float.valueOf(this.elapsedSeconds()), this.docs.size(), this.docContents()));
            } else {
                log.info((Object)String.format("%8.3f added %d documents: \n%s", Float.valueOf(this.elapsedSeconds()), this.docs.size(), this.docUris()));
            }
        }

        private boolean showDocumentContents() {
            return DeveloperSettings.getInstance().getBoolean(Key.SEARCH_INDEX_SHOW_DOCUMENTS);
        }

        private String docUris() {
            StringBuilder sb = new StringBuilder();
            for (SearchInputDocument doc : this.docs) {
                sb.append(Formatter.getValueFromField(doc, "URI")).append(" - ").append(Formatter.getValueFromField(doc, "nameRaw")).append("\n");
            }
            return sb.toString();
        }

        private String docContents() {
            StringBuilder sb = new StringBuilder();
            for (SearchInputDocument doc : this.docs) {
                sb.append(Formatter.format(doc));
            }
            return sb.toString();
        }
    }
}

