/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.base;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchFacetField;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocumentList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BaseSearchResponse
implements SearchResponse {
    private final Map<String, Map<String, List<String>>> highlighting;
    private final Map<String, SearchFacetField> facetFields;
    private final SearchResultDocumentList results;

    public BaseSearchResponse(Map<String, Map<String, List<String>>> highlighting, Map<String, SearchFacetField> facetFields, SearchResultDocumentList results) {
        this.highlighting = highlighting;
        this.facetFields = facetFields;
        this.results = results;
    }

    @Override
    public SearchResultDocumentList getResults() {
        return this.results;
    }

    @Override
    public Map<String, Map<String, List<String>>> getHighlighting() {
        return Collections.unmodifiableMap(this.highlighting);
    }

    @Override
    public SearchFacetField getFacetField(String name) {
        return this.facetFields.get(name);
    }

    @Override
    public List<SearchFacetField> getFacetFields() {
        return new ArrayList<SearchFacetField>(this.facetFields.values());
    }

    public String toString() {
        return "BaseSearchResponse[highlighting=" + this.highlighting + ", facetFields=" + this.facetFields + ", results=" + this.results + "]";
    }
}

