/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifier;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifierList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DocumentModifierListDeveloper
implements DocumentModifierList {
    private static final Log log = LogFactory.getLog(DocumentModifierListDeveloper.class);
    private final List<ModifierTiming> timings;
    private final AtomicInteger count = new AtomicInteger();

    public DocumentModifierListDeveloper(Collection<? extends DocumentModifier> modifiers) {
        ArrayList<ModifierTiming> list = new ArrayList<ModifierTiming>();
        for (DocumentModifier documentModifier : modifiers) {
            list.add(new ModifierTiming(documentModifier));
        }
        this.timings = Collections.unmodifiableList(list);
    }

    @Override
    public void startIndexing() {
    }

    @Override
    public void modifyDocument(Individual ind, SearchInputDocument doc) {
        this.count.incrementAndGet();
        for (ModifierTiming timing : this.timings) {
            long startTime = System.currentTimeMillis();
            timing.getModifier().modifyDocument(ind, doc);
            timing.addElapsedTime(System.currentTimeMillis() - startTime);
        }
    }

    @Override
    public void stopIndexing() {
        String message = String.format("Timings for %d modifiers after %d calls:", this.timings.size(), this.count.get());
        for (ModifierTiming timing : this.timings) {
            int totalMillis = timing.getTotal();
            float totalSeconds = (float)totalMillis / 1000.0f;
            int average = this.count.get() == 0 ? 0 : totalMillis / this.count.get();
            message = message + String.format("\n   count: %7d, total: %9.3fsec, average: %4dms-- %1.200s", this.count.get(), Float.valueOf(totalSeconds), average, timing.getModifier());
        }
        log.info((Object)message);
    }

    private static class ModifierTiming {
        private final DocumentModifier modifier;
        private final AtomicLong totalElapsedMillis = new AtomicLong();

        public ModifierTiming(DocumentModifier modifier) {
            this.modifier = modifier;
        }

        public DocumentModifier getModifier() {
            return this.modifier;
        }

        public int getTotal() {
            return (int)this.totalElapsedMillis.get();
        }

        public void addElapsedTime(long elapsed) {
            this.totalElapsedMillis.addAndGet(elapsed);
        }
    }
}

