/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifier;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.SelectQueryHolder;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.SelectQueryRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectQueryDocumentModifier
implements DocumentModifier,
ContextModelsUser {
    private static final Log log = LogFactory.getLog(SelectQueryDocumentModifier.class);
    private RDFService rdfService;
    private String label;
    private List<String> queries = new ArrayList<String>();
    private List<String> fieldNames = new ArrayList<String>();
    private Set<String> typeRestrictions = new HashSet<String>();

    @Override
    public void setContextModels(ContextModelAccess models) {
        this.rdfService = models.getRDFService(ModelAccess.WhichService.CONTENT);
    }

    @Property(uri="http://www.w3.org/2000/01/rdf-schema#label")
    public void setLabel(String l) {
        this.label = l;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasSelectQuery")
    public void addQuery(String query) {
        this.queries.add(query);
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasTargetField")
    public void addTargetField(String fieldName) {
        this.fieldNames.add(fieldName);
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasTypeRestriction")
    public void addTypeRestriction(String typeUri) {
        this.typeRestrictions.add(typeUri);
    }

    @Validation
    public void validate() {
        if (this.label == null) {
            this.label = this.getClass().getSimpleName() + ":" + this.hashCode();
        }
        if (this.fieldNames.isEmpty()) {
            this.fieldNames.add("ALLTEXT");
            this.fieldNames.add("ALLTEXTUNSTEMMED");
        }
        if (this.queries.isEmpty()) {
            throw new IllegalStateException("Configuration contains no queries for " + this.label);
        }
    }

    public String toString() {
        return this.label == null ? super.toString() : this.label;
    }

    @Override
    public void modifyDocument(Individual ind, SearchInputDocument doc) {
        if (this.passesTypeRestrictions(ind)) {
            List<String> values = this.getTextForQueries(ind);
            for (String fieldName : this.fieldNames) {
                doc.addField(fieldName, new Object[]{values});
            }
        }
    }

    private boolean passesTypeRestrictions(Individual ind) {
        if (this.typeRestrictions.isEmpty()) {
            return true;
        }
        for (VClass type : ind.getVClasses()) {
            if (!this.typeRestrictions.contains(type.getURI())) continue;
            return true;
        }
        return false;
    }

    private List<String> getTextForQueries(Individual ind) {
        ArrayList<String> list = new ArrayList<String>();
        for (String query : this.queries) {
            list.addAll(this.getTextForQuery(query, ind));
        }
        return list;
    }

    private List<String> getTextForQuery(String query, Individual ind) {
        try {
            SelectQueryHolder queryHolder = new SelectQueryHolder(query).bindToUri("uri", ind.getURI());
            List<String> list = SelectQueryRunner.createQueryContext(this.rdfService, queryHolder).execute().getStringFields(new String[0]).flatten();
            log.debug((Object)(this.label + " - query: '" + query + "' returns " + list));
            return list;
        }
        catch (Throwable t) {
            log.error((Object)("problem while running query '" + query + "'"), t);
            return Collections.emptyList();
        }
    }

    @Override
    public void shutdown() {
    }
}

