/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.indexing;

import com.hp.hpl.jena.rdf.model.Statement;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinder;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinderList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexingUriFinderListDeveloper
implements IndexingUriFinderList {
    private static final Log log = LogFactory.getLog(IndexingUriFinderListDeveloper.class);
    private final List<FinderTiming> timings;
    private final AtomicInteger count = new AtomicInteger();

    public IndexingUriFinderListDeveloper(Collection<? extends IndexingUriFinder> finders) {
        ArrayList<FinderTiming> list = new ArrayList<FinderTiming>();
        for (IndexingUriFinder indexingUriFinder : finders) {
            list.add(new FinderTiming(indexingUriFinder));
        }
        this.timings = Collections.unmodifiableList(list);
    }

    @Override
    public void startIndexing() {
        for (FinderTiming timing : this.timings) {
            timing.getFinder().startIndexing();
        }
    }

    @Override
    public Set<String> findAdditionalUris(Statement stmt) {
        this.count.incrementAndGet();
        HashSet<String> uris = new HashSet<String>();
        for (FinderTiming timing : this.timings) {
            long startTime = System.currentTimeMillis();
            uris.addAll(timing.getFinder().findAdditionalURIsToIndex(stmt));
            timing.addElapsedTime(System.currentTimeMillis() - startTime);
        }
        return uris;
    }

    @Override
    public void stopIndexing() {
        for (FinderTiming timing : this.timings) {
            timing.getFinder().endIndexing();
        }
        String message = String.format("Timings for %d URI finders after %d calls:", this.timings.size(), this.count.get());
        for (FinderTiming timing : this.timings) {
            int totalMillis = timing.getTotal();
            float totalSeconds = (float)totalMillis / 1000.0f;
            int average = this.count.get() == 0 ? 0 : totalMillis / this.count.get();
            message = message + String.format("\n   count: %7d, total: %9.3fsec, average: %4dms-- %1.200s", this.count.get(), Float.valueOf(totalSeconds), average, timing.getFinder());
        }
        log.info((Object)message);
    }

    private static class FinderTiming {
        private final IndexingUriFinder finder;
        private final AtomicLong totalElapsedMillis = new AtomicLong();

        public FinderTiming(IndexingUriFinder finder) {
            this.finder = finder;
        }

        public IndexingUriFinder getFinder() {
            return this.finder;
        }

        public int getTotal() {
            return (int)this.totalElapsedMillis.get();
        }

        public void addElapsedTime(long elapsed) {
            this.totalElapsedMillis.addAndGet(elapsed);
        }
    }
}

