/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.tasks;

import com.hp.hpl.jena.rdf.model.Statement;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexerStatus;
import edu.cornell.mannlib.vitro.webapp.searchindex.SearchIndexerImpl;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifierList;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluderList;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinderList;
import edu.cornell.mannlib.vitro.webapp.searchindex.tasks.FindUrisForStatementWorkUnit;
import edu.cornell.mannlib.vitro.webapp.searchindex.tasks.UpdateUrisTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateStatementsTask
implements SearchIndexerImpl.Task {
    private static final Log log = LogFactory.getLog(UpdateStatementsTask.class);
    private final SearchIndexerImpl.IndexerConfig config;
    private UpdateStatementsTaskImpl impl;
    private List<Statement> changes;

    public UpdateStatementsTask(SearchIndexerImpl.IndexerConfig config, List<Statement> changes) {
        this.config = config;
        this.changes = new ArrayList<Statement>(changes);
    }

    @Override
    public void run() {
        this.impl = new UpdateStatementsTaskImpl(this.config, this.changes);
        this.impl.run();
    }

    @Override
    public SearchIndexerStatus getStatus() {
        return this.impl == null ? SearchIndexerStatus.idle() : this.impl.getStatus();
    }

    @Override
    public void notifyWorkUnitCompletion(Runnable workUnit) {
        if (this.impl != null) {
            this.impl.notifyWorkUnitCompletion(workUnit);
        }
    }

    private static class UpdateStatementsTaskImpl
    implements SearchIndexerImpl.Task {
        private final List<Statement> changes;
        private final IndexingUriFinderList uriFinders;
        private final SearchIndexExcluderList excluders;
        private final DocumentModifierList modifiers;
        private final IndividualDao indDao;
        private final SearchIndexerImpl.ListenerList listeners;
        private final SearchIndexerImpl.WorkerThreadPool pool;
        private final Set<String> uris;
        private final Status status;

        public UpdateStatementsTaskImpl(SearchIndexerImpl.IndexerConfig config, List<Statement> changes) {
            this.changes = changes;
            this.uriFinders = config.uriFinderList();
            this.excluders = config.excluderList();
            this.modifiers = config.documentModifierList();
            this.indDao = config.individualDao();
            this.listeners = config.listenerList();
            this.pool = config.workerThreadPool();
            this.uris = Collections.synchronizedSet(new HashSet());
            this.status = new Status(changes.size(), 500, this.listeners);
        }

        @Override
        public void run() {
            this.listeners.fireEvent(new SearchIndexer.Event(SearchIndexer.Event.Type.START_STATEMENTS, this.getStatus()));
            this.findAffectedUris();
            this.updateTheUris();
            this.listeners.fireEvent(new SearchIndexer.Event(SearchIndexer.Event.Type.STOP_STATEMENTS, this.getStatus()));
        }

        private void findAffectedUris() {
            log.debug((Object)"Tell finders we are starting.");
            this.uriFinders.startIndexing();
            for (Statement stmt : this.changes) {
                if (this.isInterrupted()) {
                    log.info((Object)("Interrupted: " + this.status.getSearchIndexerStatus()));
                    return;
                }
                this.findUrisForStatement(stmt);
            }
            this.waitForWorkUnitsToComplete();
            log.debug((Object)"Tell finders we are stopping.");
            this.uriFinders.stopIndexing();
        }

        private boolean isInterrupted() {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return true;
            }
            return false;
        }

        private void findUrisForStatement(Statement stmt) {
            FindUrisForStatementWorkUnit workUnit = new FindUrisForStatementWorkUnit(stmt, this.uriFinders);
            this.pool.submit(workUnit, this);
            log.debug((Object)("scheduled uri finders for " + stmt));
        }

        private void waitForWorkUnitsToComplete() {
            this.pool.waitUntilIdle();
        }

        private void updateTheUris() {
            UpdateUrisTask.runNow(this.uris, this.excluders, this.modifiers, this.indDao, this.listeners, this.pool);
        }

        @Override
        public SearchIndexerStatus getStatus() {
            return this.status.getSearchIndexerStatus();
        }

        @Override
        public void notifyWorkUnitCompletion(Runnable workUnit) {
            FindUrisForStatementWorkUnit worker = (FindUrisForStatementWorkUnit)workUnit;
            Set<String> foundUris = worker.getUris();
            Statement stmt = worker.getStatement();
            log.debug((Object)("Found " + foundUris.size() + " uris for statement: " + stmt));
            this.uris.addAll(foundUris);
            this.status.incrementProcessed();
        }

        private static class Status {
            private final int total;
            private final int progressInterval;
            private final SearchIndexerImpl.ListenerList listeners;
            private int processed = 0;
            private Date since = new Date();

            public Status(int total, int progressInterval, SearchIndexerImpl.ListenerList listeners) {
                this.total = total;
                this.progressInterval = progressInterval;
                this.listeners = listeners;
            }

            public synchronized void incrementProcessed() {
                ++this.processed;
                this.since = new Date();
                this.maybeFireProgressEvent();
            }

            private void maybeFireProgressEvent() {
                if (this.processed > 0 && this.processed % this.progressInterval == 0) {
                    this.listeners.fireEvent(new SearchIndexer.Event(SearchIndexer.Event.Type.PROGRESS, this.getSearchIndexerStatus()));
                }
            }

            public synchronized SearchIndexerStatus getSearchIndexerStatus() {
                int remaining = this.total - this.processed;
                return new SearchIndexerStatus(SearchIndexerStatus.State.PROCESSING_STMTS, this.since, new SearchIndexerStatus.StatementCounts(this.processed, remaining, this.total));
            }
        }
    }
}

