/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.tasks;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineNotRespondingException;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexerStatus;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexerUtils;
import edu.cornell.mannlib.vitro.webapp.searchindex.SearchIndexerImpl;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifierList;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluder;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluderList;
import edu.cornell.mannlib.vitro.webapp.searchindex.tasks.UpdateDocumentWorkUnit;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateUrisTask
implements SearchIndexerImpl.Task {
    private static final Log log = LogFactory.getLog(UpdateUrisTask.class);
    private final SearchIndexerImpl.IndexerConfig config;
    private UpdateUrisTaskImpl impl;
    private final Collection<String> uris;
    private Date since = new Date();

    public UpdateUrisTask(SearchIndexerImpl.IndexerConfig config, Collection<String> uris) {
        this.config = config;
        this.uris = new HashSet<String>(uris);
    }

    static void runNow(Collection<String> uris, SearchIndexExcluderList excluders, DocumentModifierList modifiers, IndividualDao indDao, SearchIndexerImpl.ListenerList listeners, SearchIndexerImpl.WorkerThreadPool pool) {
        UpdateUrisTaskImpl impl = new UpdateUrisTaskImpl(uris, excluders, modifiers, indDao, listeners, pool);
        impl.run();
    }

    @Override
    public void run() {
        this.impl = new UpdateUrisTaskImpl(this.config, this.uris);
        this.impl.run();
    }

    @Override
    public SearchIndexerStatus getStatus() {
        return this.impl == null ? SearchIndexerStatus.idle() : this.impl.getStatus();
    }

    @Override
    public void notifyWorkUnitCompletion(Runnable workUnit) {
        if (this.impl != null) {
            this.impl.notifyWorkUnitCompletion(workUnit);
        }
    }

    public static class ExcludeIfNoVClasses
    implements SearchIndexExcluder {
        @Override
        public String checkForExclusion(Individual ind) {
            List<VClass> vclasses = ind.getVClasses(false);
            if (vclasses == null || vclasses.isEmpty()) {
                return "Individual " + ind + " has no classes.";
            }
            return null;
        }

        public String toString() {
            return "Internal: ExcludeIfNoVClasses";
        }
    }

    private static class UpdateUrisTaskImpl
    implements SearchIndexerImpl.Task {
        private final Collection<String> uris;
        private final IndividualDao indDao;
        private final SearchIndexExcluderList excluders;
        private final DocumentModifierList modifiers;
        private final SearchIndexerImpl.ListenerList listeners;
        private final SearchIndexerImpl.WorkerThreadPool pool;
        private final Status status;
        private final SearchEngine searchEngine;

        public UpdateUrisTaskImpl(SearchIndexerImpl.IndexerConfig config, Collection<String> uris) {
            this.excluders = config.excluderList();
            this.modifiers = config.documentModifierList();
            this.indDao = config.individualDao();
            this.listeners = config.listenerList();
            this.pool = config.workerThreadPool();
            this.uris = uris;
            this.status = new Status(this, uris.size(), 500);
            this.searchEngine = ApplicationUtils.instance().getSearchEngine();
        }

        public UpdateUrisTaskImpl(Collection<String> uris, SearchIndexExcluderList excluders, DocumentModifierList modifiers, IndividualDao indDao, SearchIndexerImpl.ListenerList listeners, SearchIndexerImpl.WorkerThreadPool pool) {
            log.debug((Object)("Updating " + uris.size() + " uris."));
            this.uris = uris;
            this.excluders = excluders;
            this.modifiers = modifiers;
            this.indDao = indDao;
            this.listeners = listeners;
            this.pool = pool;
            this.status = new Status(this, uris.size(), 500);
            this.searchEngine = ApplicationUtils.instance().getSearchEngine();
        }

        @Override
        public void run() {
            this.listeners.fireEvent(new SearchIndexer.Event(SearchIndexer.Event.Type.START_URIS, this.status.getSearchIndexerStatus()));
            this.excluders.startIndexing();
            this.modifiers.startIndexing();
            for (String uri : this.uris) {
                if (this.isInterrupted()) {
                    log.info((Object)("Interrupted: " + this.status.getSearchIndexerStatus()));
                    break;
                }
                if (uri == null) continue;
                Individual ind = this.getIndividual(uri);
                if (ind == null) {
                    this.deleteDocument(uri);
                    continue;
                }
                if (this.isExcluded(ind)) {
                    this.excludeDocument(uri);
                    continue;
                }
                this.updateDocument(ind);
            }
            this.pool.waitUntilIdle();
            this.commitChanges();
            this.excluders.stopIndexing();
            this.modifiers.stopIndexing();
            this.listeners.fireEvent(new SearchIndexer.Event(SearchIndexer.Event.Type.STOP_URIS, this.status.getSearchIndexerStatus()));
        }

        private boolean isInterrupted() {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return true;
            }
            return false;
        }

        private Individual getIndividual(String uri) {
            Individual ind = this.indDao.getIndividualByURI(uri);
            if (ind == null) {
                log.debug((Object)("Found no individual for '" + uri + "'"));
            }
            return ind;
        }

        private boolean isExcluded(Individual ind) {
            return this.excluders.isExcluded(ind);
        }

        private void deleteDocument(String uri) {
            try {
                this.searchEngine.deleteById(SearchIndexerUtils.getIdForUri(uri));
                this.status.incrementDeletes();
                log.debug((Object)("deleted '" + uri + "' from search index."));
            }
            catch (SearchEngineNotRespondingException e) {
                log.warn((Object)("Failed to delete '" + uri + "' from search index: " + "the search engine is not responding."));
            }
            catch (Exception e) {
                log.warn((Object)("Failed to delete '" + uri + "' from search index"), (Throwable)e);
            }
        }

        private void excludeDocument(String uri) {
            try {
                this.searchEngine.deleteById(SearchIndexerUtils.getIdForUri(uri));
                this.status.incrementExclusions();
                log.debug((Object)("excluded '" + uri + "' from search index."));
            }
            catch (SearchEngineNotRespondingException e) {
                log.warn((Object)("Failed to exclude '" + uri + "' from search index: " + "the search engine is not responding."), (Throwable)e);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to exclude '" + uri + "' from search index"), (Throwable)e);
            }
        }

        private void updateDocument(Individual ind) {
            UpdateDocumentWorkUnit workUnit = new UpdateDocumentWorkUnit(ind, this.modifiers);
            this.pool.submit(workUnit, this);
            log.debug((Object)("scheduled update to " + ind));
        }

        private void fireEvent(SearchIndexer.Event event) {
            this.listeners.fireEvent(event);
            if (event.getType() == SearchIndexer.Event.Type.PROGRESS || event.getType() == SearchIndexer.Event.Type.STOP_URIS) {
                this.commitChanges();
            }
        }

        private void commitChanges() {
            try {
                this.searchEngine.commit();
            }
            catch (SearchEngineException e) {
                log.warn((Object)"Failed to commit changes.", (Throwable)e);
            }
        }

        @Override
        public void notifyWorkUnitCompletion(Runnable workUnit) {
            log.debug((Object)("completed update to " + ((UpdateDocumentWorkUnit)workUnit).getInd()));
            this.status.incrementUpdates();
        }

        @Override
        public SearchIndexerStatus getStatus() {
            return this.status.getSearchIndexerStatus();
        }

        private static class Status {
            private final UpdateUrisTaskImpl parent;
            private final int total;
            private final int progressInterval;
            private int updated = 0;
            private int deleted = 0;
            private int excluded = 0;
            private Date since = new Date();

            public Status(UpdateUrisTaskImpl parent, int total, int progressInterval) {
                this.parent = parent;
                this.total = total;
                this.progressInterval = progressInterval;
            }

            public synchronized void incrementUpdates() {
                ++this.updated;
                this.since = new Date();
                this.maybeFireProgressEvent();
            }

            public synchronized void incrementDeletes() {
                ++this.deleted;
                this.since = new Date();
            }

            public synchronized void incrementExclusions() {
                ++this.excluded;
                this.since = new Date();
            }

            private void maybeFireProgressEvent() {
                if (this.updated > 0 && this.updated % this.progressInterval == 0) {
                    this.parent.fireEvent(new SearchIndexer.Event(SearchIndexer.Event.Type.PROGRESS, this.getSearchIndexerStatus()));
                }
            }

            public synchronized SearchIndexerStatus getSearchIndexerStatus() {
                int remaining = this.total - this.updated - this.deleted - this.excluded;
                return new SearchIndexerStatus(SearchIndexerStatus.State.PROCESSING_URIS, this.since, new SearchIndexerStatus.UriCounts(this.excluded, this.deleted, this.updated, remaining, this.total));
            }
        }
    }
}

