/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.sparql;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetObjectClasses
extends BaseEditController {
    private static final Log log = LogFactory.getLog(GetObjectClasses.class);

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.USE_MISCELLANEOUS_PAGES.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        String predicate = vreq.getParameter("predicate");
        if (predicate == null || predicate.trim().equals("")) {
            return;
        }
        ObjectPropertyDao odao = vreq.getUnfilteredWebappDaoFactory().getObjectPropertyDao();
        ObjectProperty oprop = odao.getObjectPropertyByURI(predicate);
        VClassDao vcDao = vreq.getUnfilteredWebappDaoFactory().getVClassDao();
        VClass vClass = oprop.getRangeVClassURI() != null ? vcDao.getVClassByURI(oprop.getRangeVClassURI()) : null;
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        String respo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        respo = respo + "<options>";
        if (vClass != null) {
            respo = respo + "<option><key>" + vClass.getPickListName() + "</key>" + "<value>" + vClass.getURI() + "</value>" + "</option>";
        } else {
            List<VClassGroup> classGroups = vreq.getUnfilteredWebappDaoFactory().getVClassGroupDao().getPublicGroupsWithVClasses(true, true, false);
            for (VClassGroup group : classGroups) {
                List<VClass> classes = group.getVitroClassList();
                for (VClass clazz : classes) {
                    respo = respo + "<option><key>" + clazz.getPickListName() + "</key>" + "<value>" + clazz.getURI() + "</value>" + "</option>";
                }
            }
        }
        respo = respo + "</options>";
        out.println(respo);
        out.flush();
        out.close();
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

