/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.startup;

import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StartupManager
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(StartupManager.class);
    public static final String FILE_OF_STARTUP_LISTENERS = "/WEB-INF/resources/startup_listeners.txt";
    private final List<ServletContextListener> initializeList = new ArrayList<ServletContextListener>();
    private ServletContext ctx;
    private StartupStatus ss;

    public void contextInitialized(ServletContextEvent sce) {
        this.ctx = sce.getServletContext();
        this.ss = StartupStatus.getBean(this.ctx);
        try {
            this.findAndInstantiateListeners();
            for (ServletContextListener listener : this.initializeList) {
                if (this.ss.isStartupAborted()) {
                    this.ss.listenerNotExecuted(listener);
                    continue;
                }
                this.initialize(listener, sce);
            }
            log.info((Object)"Called 'contextInitialized' on all listeners.");
        }
        catch (Exception e) {
            this.ss.fatal(this, "Startup threw an unexpected exception.", e);
            log.error((Object)"Startup threw an unexpected exception.", (Throwable)e);
        }
        catch (Throwable t) {
            log.fatal((Object)"Startup threw an unexpected error.", t);
            throw t;
        }
    }

    private void findAndInstantiateListeners() {
        List<String> classNames = this.readFileOfListeners();
        for (String className : classNames) {
            ServletContextListener listener = this.instantiateListener(className);
            if (listener == null) continue;
            this.initializeList.add(listener);
        }
        this.checkForDuplicateListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFileOfListeners() {
        ArrayList<String> list = new ArrayList<String>();
        InputStream is = null;
        BufferedReader br = null;
        try {
            String line;
            is = this.ctx.getResourceAsStream(FILE_OF_STARTUP_LISTENERS);
            br = new BufferedReader(new InputStreamReader(is));
            while (null != (line = br.readLine())) {
                String trimmed = line.trim();
                if (trimmed.isEmpty() || trimmed.startsWith("#")) continue;
                list.add(trimmed);
            }
        }
        catch (NullPointerException e) {
            this.ss.fatal(this, "Unable to locate the list of startup listeners: /WEB-INF/resources/startup_listeners.txt");
        }
        catch (IOException e) {
            this.ss.fatal(this, "Failed while processing the list of startup listeners:  /WEB-INF/resources/startup_listeners.txt", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
        log.debug((Object)("Classnames of listeners = " + list));
        return list;
    }

    private ServletContextListener instantiateListener(String className) {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            return (ServletContextListener)o;
        }
        catch (ClassCastException e) {
            this.ss.fatal(this, "Instance of '" + className + "' is not a ServletContextListener", e);
            return null;
        }
        catch (Exception e) {
            this.ss.fatal(this, "Failed to instantiate listener: '" + className + "'", e);
            return null;
        }
        catch (ExceptionInInitializerError e) {
            this.ss.fatal(this, "Failed to instantiate listener: '" + className + "'", e);
            return null;
        }
    }

    private void initialize(ServletContextListener listener, ServletContextEvent sce) {
        try {
            log.debug((Object)("Initializing '" + listener.getClass().getName() + "'"));
            listener.contextInitialized(sce);
            this.ss.listenerExecuted(listener);
        }
        catch (Exception e) {
            this.ss.fatal(listener, "Threw unexpected exception", e);
        }
        catch (Throwable t) {
            log.fatal((Object)(listener + " Threw unexpected error"), t);
            throw t;
        }
    }

    private void checkForDuplicateListeners() {
        for (int i = 0; i < this.initializeList.size(); ++i) {
            for (int j = i + 1; j < this.initializeList.size(); ++j) {
                ServletContextListener iListener = this.initializeList.get(i);
                ServletContextListener jListener = this.initializeList.get(j);
                if (!iListener.getClass().equals(jListener.getClass())) continue;
                this.ss.fatal(this, "File contains duplicate listener classes: '" + iListener.getClass().getName() + "'");
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ArrayList<ServletContextListener> destroyList = new ArrayList<ServletContextListener>(this.initializeList);
        Collections.reverse(destroyList);
        for (ServletContextListener listener : destroyList) {
            try {
                log.debug((Object)("Destroying '" + listener.getClass().getName() + "'"));
                listener.contextDestroyed(sce);
            }
            catch (Exception e) {
                log.error((Object)("Unexpected exception from contextDestroyed() on '" + listener.getClass().getName() + "'"), (Throwable)e);
            }
            catch (Throwable t) {
                log.fatal((Object)("Unexpected error from contextDestroyed() on '" + listener.getClass().getName() + "'"), t);
                throw t;
            }
        }
        log.info((Object)"Called 'contextDestroyed' on all listeners.");
    }
}

