/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.tboxreasoner;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ReasonerConfiguration;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ReasonerStatementPattern;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxChanges;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxReasoner;
import java.util.LinkedList;
import java.util.Set;

public class PatternListBuilder {
    private static final String OWL_NS = "http://www.w3.org/2002/07/owl#";
    private final ReasonerConfiguration reasonerConfiguration;
    private final TBoxReasoner reasoner;
    private final TBoxChanges changes;

    public PatternListBuilder(ReasonerConfiguration reasonerConfiguration, TBoxReasoner reasoner, TBoxChanges changes) {
        this.reasonerConfiguration = reasonerConfiguration;
        this.reasoner = reasoner;
        this.changes = changes;
    }

    public LinkedList<ReasonerStatementPattern> build() {
        LinkedList<ReasonerStatementPattern> patterns = new LinkedList<ReasonerStatementPattern>();
        Set<ReasonerStatementPattern> allowSet = this.reasonerConfiguration.getInferenceReceivingPatternAllowSet();
        if (allowSet != null) {
            patterns.addAll(allowSet);
        } else {
            patterns.add(ReasonerStatementPattern.ANY_OBJECT_PROPERTY);
        }
        if (this.reasonerConfiguration.getQueryForAllObjectProperties()) {
            for (ObjectProperty objProp : this.reasoner.listObjectProperties()) {
                if (OWL_NS.equals(objProp.getNameSpace())) continue;
                patterns.add(ReasonerStatementPattern.objectPattern((Property)objProp));
            }
            for (String uri : this.changes.getDeletedObjectPropertyUris()) {
                patterns.add(ReasonerStatementPattern.objectPattern(ResourceFactory.createProperty((String)uri)));
            }
        }
        if (this.reasonerConfiguration.getQueryForAllDatatypeProperties()) {
            for (DatatypeProperty dataProp : this.reasoner.listDatatypeProperties()) {
                if (OWL_NS.equals(dataProp.getNameSpace())) continue;
                patterns.add(ReasonerStatementPattern.objectPattern((Property)dataProp));
            }
            for (String uri : this.changes.getDeletedDataPropertyUris()) {
                patterns.add(ReasonerStatementPattern.objectPattern(ResourceFactory.createProperty((String)uri)));
            }
        }
        return patterns;
    }
}

