/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.tboxreasoner.impl.jfact;

import com.hp.hpl.jena.ontology.Restriction;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.tboxreasoner.TBoxReasonerModule;
import edu.cornell.mannlib.vitro.webapp.modules.tboxreasoner.TBoxReasonerStatus;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ReasonerConfiguration;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.impl.BasicTBoxReasonerDriver;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.impl.jfact.JFactTBoxReasoner;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JFactTBoxReasonerModule
implements TBoxReasonerModule {
    private static final Log log = LogFactory.getLog(JFactTBoxReasonerModule.class);
    private JFactTBoxReasoner reasoner;
    private BasicTBoxReasonerDriver driver;

    @Override
    public void startup(Application application, ComponentStartupStatus ss) {
        ServletContext ctx = application.getServletContext();
        ContextModelAccess contextModels = ModelAccess.on(ctx);
        this.reasoner = new JFactTBoxReasoner();
        this.driver = new BasicTBoxReasonerDriver(contextModels.getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox"), contextModels.getOntModel("http://vitro.mannlib.cornell.edu/default/inferred-tbox").getBaseModel(), contextModels.getOntModel("vitro:tboxOntModel"), this.reasoner, ReasonerConfiguration.DEFAULT);
        ss.info("JFact reasoner connected for the TBox");
        this.waitForTBoxReasoning();
    }

    @Override
    public TBoxReasonerStatus getStatus() {
        if (this.driver == null) {
            throw new IllegalStateException("JFactTBoxReasonerModule has not been started.");
        }
        return this.driver.getStatus();
    }

    @Override
    public List<Restriction> listRestrictions() {
        if (this.reasoner == null) {
            throw new IllegalStateException("JFactTBoxReasonerModule has not been started.");
        }
        return this.reasoner.listRestrictions();
    }

    @Override
    public void waitForTBoxReasoning() {
        for (int sleeps = 0; 0 == sleeps || sleeps < 1000 && this.getStatus().isReasoning(); ++sleeps) {
            if ((sleeps - 1) % 10 == 0) {
                log.info((Object)"Waiting for initial TBox reasoning to complete");
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void shutdown(Application application) {
        this.driver.shutdown();
    }
}

