/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.triplesource.impl;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.JoinedOntModelCache;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.ModelMakerOntModelCache;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.OntModelCache;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.UnionModelsOntModelsCache;
import edu.cornell.mannlib.vitro.webapp.modules.tripleSource.ConfigurationTripleSource;
import edu.cornell.mannlib.vitro.webapp.modules.tripleSource.ContentTripleSource;
import edu.cornell.mannlib.vitro.webapp.modules.tripleSource.TripleSource;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.triplesource.CombinedTripleSource;
import edu.cornell.mannlib.vitro.webapp.triplesource.ShortTermCombinedTripleSource;
import edu.cornell.mannlib.vitro.webapp.triplesource.impl.BasicShortTermCombinedTripleSource;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.EnumMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class BasicCombinedTripleSource
implements CombinedTripleSource {
    public static final UnionModelsOntModelsCache.UnionSpec[] CONTENT_UNIONS = new UnionModelsOntModelsCache.UnionSpec[]{UnionModelsOntModelsCache.UnionSpec.base("http://vitro.mannlib.cornell.edu/default/vitro-kb-2").plus("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf").yields("vitro:aboxOntModel"), UnionModelsOntModelsCache.UnionSpec.base("http://vitro.mannlib.cornell.edu/default/asserted-tbox").plus("http://vitro.mannlib.cornell.edu/default/inferred-tbox").yields("vitro:tboxOntModel"), UnionModelsOntModelsCache.UnionSpec.base("http://vitro.mannlib.cornell.edu/default/vitro-kb-2").plus("http://vitro.mannlib.cornell.edu/default/asserted-tbox").yields("vitro:baseOntModel"), UnionModelsOntModelsCache.UnionSpec.base("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf").plus("http://vitro.mannlib.cornell.edu/default/inferred-tbox").yields("vitro:inferenceOntModel")};
    private final Map<ModelAccess.WhichService, TripleSource> sources = new EnumMap<ModelAccess.WhichService, TripleSource>(ModelAccess.WhichService.class);
    private final Map<ModelAccess.WhichService, OntModelCache> ontModels;
    private final OntModelCache ontModelCache;

    public BasicCombinedTripleSource(ContentTripleSource contentSource, ConfigurationTripleSource configurationSource) {
        this.sources.put(ModelAccess.WhichService.CONTENT, contentSource);
        this.sources.put(ModelAccess.WhichService.CONFIGURATION, configurationSource);
        this.ontModels = new EnumMap<ModelAccess.WhichService, OntModelCache>(ModelAccess.WhichService.class);
        this.ontModels.put(ModelAccess.WhichService.CONTENT, new UnionModelsOntModelsCache(new ModelMakerOntModelCache(this.getModelMaker(ModelAccess.WhichService.CONTENT)), CONTENT_UNIONS));
        this.ontModels.put(ModelAccess.WhichService.CONFIGURATION, new ModelMakerOntModelCache(this.getModelMaker(ModelAccess.WhichService.CONFIGURATION)));
        this.ontModelCache = new JoinedOntModelCache(this.ontModels.get(ModelAccess.WhichService.CONTENT), this.ontModels.get(ModelAccess.WhichService.CONFIGURATION));
    }

    protected OntModelCache getOntModels(ModelAccess.WhichService whichService) {
        return this.ontModels.get(whichService);
    }

    protected RDFServiceFactory getRDFServiceFactory(ModelAccess.WhichService whichService) {
        return this.sources.get(whichService).getRDFServiceFactory();
    }

    @Override
    public RDFService getRDFService(ModelAccess.WhichService whichService) {
        return this.sources.get(whichService).getRDFService();
    }

    @Override
    public Dataset getDataset(ModelAccess.WhichService whichService) {
        return this.sources.get(whichService).getDataset();
    }

    @Override
    public ModelMaker getModelMaker(ModelAccess.WhichService whichService) {
        return this.sources.get(whichService).getModelMaker();
    }

    @Override
    public OntModelCache getOntModelCache() {
        return this.ontModelCache;
    }

    @Override
    public ShortTermCombinedTripleSource getShortTermCombinedTripleSource(HttpServletRequest req) {
        return new BasicShortTermCombinedTripleSource(req, this, this.sources);
    }

    public String toString() {
        return "BasicCombinedTripleSource[" + ToString.hashHex(this) + ", sources=" + this.sources + ", ontModels=" + this.ontModelCache + "]";
    }
}

