/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.triplesource.impl.sdb;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.LayoutType;
import com.hp.hpl.jena.sdb.util.StoreUtils;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceModelMaker;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.MemoryMappingModelMaker;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.ModelMakerWithPersistentEmptyModels;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.MaskingOntModelCache;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.ModelMakerOntModelCache;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.OntModelCache;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.UnionModelsOntModelsCache;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.tripleSource.ContentTripleSource;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.sdb.RDFServiceFactorySDB;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.logging.LoggingRDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.JenaDataSourceSetupBase;
import edu.cornell.mannlib.vitro.webapp.triplesource.impl.BasicCombinedTripleSource;
import edu.cornell.mannlib.vitro.webapp.triplesource.impl.sdb.SDBConnectionSmokeTests;
import edu.cornell.mannlib.vitro.webapp.triplesource.impl.sdb.SDBDataSource;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentTripleSourceSDB
extends ContentTripleSource {
    private static final Log log = LogFactory.getLog(ContentTripleSourceSDB.class);
    static final String PROPERTY_DB_URL = "VitroConnection.DataSource.url";
    static final String PROPERTY_DB_USERNAME = "VitroConnection.DataSource.username";
    static final String PROPERTY_DB_PASSWORD = "VitroConnection.DataSource.password";
    static final String PROPERTY_DB_DRIVER_CLASS_NAME = "VitroConnection.DataSource.driver";
    static final String PROPERTY_DB_TYPE = "VitroConnection.DataSource.dbtype";
    static final String PROPERTY_DB_MAX_ACTIVE = "VitroConnection.DataSource.pool.maxActive";
    static final String PROPERTY_DB_MAX_IDLE = "VitroConnection.DataSource.pool.maxIdle";
    static final String PROPERTY_DB_MAX_IDLE_TIME = "VitroConnection.DataSource.pool.maxIdleTime";
    static final String PROPERTY_DB_MAX_IDLE_TIME_EXCESS = "VitroConnection.DataSource.pool.maxIdleTimeExcess";
    static final String PROPERTY_DB_VALIDATION_QUERY = "VitroConnection.DataSource.validationQuery";
    static final String PROPERTY_DB_SDB_LAYOUT = "VitroConnection.DataSource.sdb.layout";
    static final String DEFAULT_TYPE = "MySQL";
    static final String DEFAULT_DRIVER_CLASS = "com.mysql.jdbc.Driver";
    static final String DEFAULT_LAYOUT = "layout2/hash";
    static final String DEFAULT_VALIDATION_QUERY = "SELECT 1";
    static final int DEFAULT_MAXACTIVE = 40;
    static final int MINIMUM_MAXACTIVE = 20;
    static final int DEFAULT_MAXIDLE = 10;
    static final int DEFAULT_MAX_IDLE_TIME = 1800;
    static final int DEFAULT_MAX_IDLE_TIME_EXCESS = 300;
    static final boolean DEFAULT_TESTONBORROW = true;
    static final boolean DEFAULT_TESTONRETURN = true;
    private ServletContext ctx;
    private ComboPooledDataSource ds;
    private RDFServiceFactory rdfServiceFactory;
    private RDFService rdfService;
    private Dataset dataset;
    private ModelMaker modelMaker;

    @Override
    public void startup(Application application, ComponentStartupStatus ss) {
        try {
            this.ctx = application.getServletContext();
            this.configureSDBContext();
            new SDBConnectionSmokeTests(this.ctx, ss).checkDatabaseConnection();
            this.ds = new SDBDataSource(this.ctx).getDataSource();
            this.rdfServiceFactory = this.createRdfServiceFactory();
            this.rdfService = this.rdfServiceFactory.getRDFService();
            this.dataset = new RDFServiceDataset(this.rdfService);
            this.modelMaker = this.createModelMaker();
            ss.info("Initialized the content data structures for SDB");
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set up the content data structures for SDB", e);
        }
    }

    private void configureSDBContext() {
        SDB.getContext().set(SDB.unionDefaultGraph, true);
    }

    private RDFServiceFactory createRdfServiceFactory() throws SQLException {
        StoreDesc storeDesc = this.makeStoreDesc();
        Store store = this.connectStore((DataSource)this.ds, storeDesc);
        if (!this.isSetUp(store)) {
            JenaDataSourceSetupBase.thisIsFirstStartup();
            this.setupSDB(store);
        }
        return new LoggingRDFServiceFactory(new RDFServiceFactorySDB((DataSource)this.ds, storeDesc));
    }

    private boolean isSetUp(Store store) throws SQLException {
        if (!StoreUtils.isFormatted((Store)store)) {
            return false;
        }
        try {
            return SDBFactory.connectNamedModel((Store)store, (String)"http://vitro.mannlib.cornell.edu/default/asserted-tbox").size() > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    private StoreDesc makeStoreDesc() {
        ConfigurationProperties props = ConfigurationProperties.getBean(this.ctx);
        String layoutStr = props.getProperty(PROPERTY_DB_SDB_LAYOUT, DEFAULT_LAYOUT);
        String dbtypeStr = props.getProperty(PROPERTY_DB_TYPE, DEFAULT_TYPE);
        return new StoreDesc(LayoutType.fetch((String)layoutStr), DatabaseType.fetch((String)dbtypeStr));
    }

    private Store connectStore(DataSource bds, StoreDesc storeDesc) throws SQLException {
        SDBConnection conn = new SDBConnection(bds.getConnection());
        return SDBFactory.connectStore((SDBConnection)conn, (StoreDesc)storeDesc);
    }

    private void setupSDB(Store store) {
        log.info((Object)"Initializing SDB store");
        store.getTableFormatter().create();
        store.getTableFormatter().truncate();
    }

    private ModelMaker createModelMaker() {
        return ContentTripleSourceSDB.addContentDecorators(new ModelMakerWithPersistentEmptyModels(new MemoryMappingModelMaker(new RDFServiceModelMaker(this.rdfService), SMALL_CONTENT_MODELS)));
    }

    @Override
    public RDFServiceFactory getRDFServiceFactory() {
        return this.rdfServiceFactory;
    }

    @Override
    public RDFService getRDFService() {
        return this.rdfService;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public ModelMaker getModelMaker() {
        return this.modelMaker;
    }

    @Override
    public OntModelCache getShortTermOntModels(RDFService shortTermRdfService, OntModelCache longTermOntModelCache) {
        ModelMakerOntModelCache shortCache = new ModelMakerOntModelCache(ContentTripleSourceSDB.addContentDecorators(new ModelMakerWithPersistentEmptyModels(new RDFServiceModelMaker(shortTermRdfService))));
        MaskingOntModelCache combinedCache = new MaskingOntModelCache(shortCache, longTermOntModelCache, Arrays.asList(MEMORY_MAPPED_CONTENT_MODELS));
        return new UnionModelsOntModelsCache(combinedCache, BasicCombinedTripleSource.CONTENT_UNIONS);
    }

    public String toString() {
        return "ContentTripleSourceSDB[" + ToString.hashHex(this) + "]";
    }

    @Override
    public void shutdown(Application application) {
        if (this.modelMaker != null) {
            this.modelMaker.close();
        }
        if (this.dataset != null) {
            this.dataset.close();
        }
        if (this.rdfService != null) {
            this.rdfService.close();
        }
        if (this.ds != null) {
            String driverClassName = this.ds.getDriverClass();
            this.ds.close();
            this.attemptToDeregisterJdbcDriver(driverClassName);
            this.cleanupAbandonedConnectionThread(driverClassName);
        }
    }

    private void attemptToDeregisterJdbcDriver(String driverClassName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (driver.getClass().getClassLoader() != cl) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException ex) {
                log.error((Object)("Error deregistering JDBC driver {" + driver + "}"), (Throwable)ex);
            }
        }
    }

    private void cleanupAbandonedConnectionThread(String driverClassName) {
        if (!driverClassName.contains("mysql")) {
            return;
        }
        try {
            Class.forName("com.mysql.jdbc.AbandonedConnectionCleanupThread").getMethod("shutdown", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            log.info((Object)("Failed to shutdown MySQL connection cleanup thread: " + e));
        }
    }
}

