/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.triplesource.impl.virtuoso;

import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.virtuoso.RDFServiceVirtuoso;
import edu.cornell.mannlib.vitro.webapp.triplesource.impl.sparql.ContentTripleSourceSPARQL;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;

public class ContentTripleSourceVirtuoso
extends ContentTripleSourceSPARQL {
    private String baseUri;
    private String username;
    private String password;

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasBaseURI")
    public void setBaseUri(String uri) {
        if (this.baseUri != null) {
            throw new IllegalStateException("Configuration includes multiple instances of BaseURI: " + this.baseUri + ", and " + uri);
        }
        this.baseUri = uri;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasUsername")
    public void setUsername(String user) {
        if (this.username != null) {
            throw new IllegalStateException("Configuration includes multiple instances of Username: " + this.username + ", and " + user);
        }
        this.username = user;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasPassword")
    public void setPassword(String pass) {
        if (this.password != null) {
            throw new IllegalStateException("Configuration includes multiple instances of Password: " + this.password + ", and " + pass);
        }
        this.password = pass;
    }

    @Override
    @Validation
    public void validate() throws Exception {
        if (this.baseUri == null) {
            throw new IllegalStateException("Configuration did not include a BaseURI.");
        }
        if (this.username == null) {
            throw new IllegalStateException("Configuration did not include a Username.");
        }
        if (this.password == null) {
            throw new IllegalStateException("Configuration did not include a Password.");
        }
    }

    @Override
    protected RDFService createRDFService(ComponentStartupStatus ss) {
        ss.info("Using Virtuoso at " + this.baseUri + ", authenticating as " + this.username);
        return new RDFServiceVirtuoso(this.baseUri, this.username, this.password);
    }

    @Override
    public String toString() {
        return "ContentTripleSourceVirtuoso[" + ToString.hashHex(this) + ", baseUri=" + this.baseUri + ", username=" + this.username + "]";
    }
}

