/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import org.skife.csv.SimpleReader;

public class Csv2Rdf {
    private String namespace;
    private String tboxNamespace;
    private String typeName;
    private String individualNameBase;
    private String propertyNameBase;
    private char separatorChar;
    private char[] quoteChars;

    public Csv2Rdf(char[] quoteChars, String namespace, String tboxNamespace, String typeName) {
        this.separatorChar = (char)44;
        this.quoteChars = quoteChars;
        this.namespace = namespace;
        this.tboxNamespace = tboxNamespace;
        this.typeName = typeName;
        this.individualNameBase = typeName.toLowerCase();
        this.propertyNameBase = this.individualNameBase + "_";
    }

    public Csv2Rdf(char separatorChar, char[] quoteChars, String namespace, String tboxNamespace, String typeName) {
        this.separatorChar = separatorChar;
        this.quoteChars = quoteChars;
        this.namespace = namespace;
        this.tboxNamespace = tboxNamespace;
        this.typeName = typeName;
        this.individualNameBase = typeName.toLowerCase();
        this.propertyNameBase = this.individualNameBase + "_";
    }

    public Model[] convertToRdf(InputStream fis) throws IOException {
        return this.convertToRdf(fis, null, null);
    }

    public Model[] convertToRdf(InputStream fis, WebappDaoFactory wadf, Model destination) throws IOException {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel tboxOntModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ontModel.addSubModel((Model)tboxOntModel);
        OntClass theClass = tboxOntModel.createClass(this.tboxNamespace + this.typeName);
        SimpleReader cReader = new SimpleReader();
        cReader.setSeperator(this.separatorChar);
        cReader.setQuoteCharacters(this.quoteChars);
        URIGenerator uriGen = wadf != null && destination != null ? new RandomURIGenerator(wadf, destination) : new SequentialURIGenerator();
        List fileRows = cReader.parse(fis);
        String[] columnHeaders = (String[])fileRows.get(0);
        DatatypeProperty[] dpArray = new DatatypeProperty[columnHeaders.length];
        for (int i = 0; i < columnHeaders.length; ++i) {
            dpArray[i] = tboxOntModel.createDatatypeProperty(this.tboxNamespace + this.propertyNameBase + columnHeaders[i].replaceAll("\\W", ""));
        }
        Individual ind = null;
        for (int row = 1; row < fileRows.size(); ++row) {
            String uri = uriGen.getNextURI();
            ind = uri != null ? ontModel.createIndividual(uri, (Resource)theClass) : ontModel.createIndividual((Resource)theClass);
            String[] cols = (String[])fileRows.get(row);
            for (int col = 0; col < cols.length; ++col) {
                String value = cols[col].trim();
                if (value.length() <= 0) continue;
                ind.addProperty((Property)dpArray[col], value);
            }
        }
        ontModel.removeSubModel((Model)tboxOntModel);
        Model[] resultModels = new Model[]{ontModel, tboxOntModel};
        return resultModels;
    }

    private class SequentialURIGenerator
    implements URIGenerator {
        private int index = 0;

        private SequentialURIGenerator() {
        }

        @Override
        public String getNextURI() {
            ++this.index;
            return Csv2Rdf.this.namespace + Csv2Rdf.this.individualNameBase + Integer.toString(this.index);
        }
    }

    private class RandomURIGenerator
    implements URIGenerator {
        private WebappDaoFactory wadf;
        private Model destination;
        private Random random = new Random(System.currentTimeMillis());

        public RandomURIGenerator(WebappDaoFactory webappDaoFactory, Model destination) {
            this.wadf = webappDaoFactory;
            this.destination = destination;
        }

        @Override
        public String getNextURI() {
            boolean uriIsGood = false;
            boolean inDestination = false;
            String uri = null;
            if (Csv2Rdf.this.namespace != null && !Csv2Rdf.this.namespace.isEmpty()) {
                for (int attempts = 0; !uriIsGood && attempts < 30; ++attempts) {
                    uri = Csv2Rdf.this.namespace + Csv2Rdf.this.individualNameBase + this.random.nextInt(Math.min(Integer.MAX_VALUE, (int)Math.pow(2.0, attempts + 13)));
                    String errMsg = this.wadf.checkURI(uri);
                    Resource res = ResourceFactory.createResource((String)uri);
                    inDestination = this.destination.contains(res, null);
                    if (errMsg != null && !inDestination) {
                        uri = null;
                        continue;
                    }
                    uriIsGood = true;
                }
            }
            return uri;
        }
    }

    private static interface URIGenerator {
        public String getNextURI();
    }
}

