/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import fedora.client.FedoraClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class FedoraConfiguration {
    private static String FEDORA_PROPERTIES = "/WEB-INF/fedora.properties";
    public String fedoraUrl = null;
    private String adminUser = null;
    private String adminPassword = null;
    private String pidNamespace = null;
    private String configurationStatus = "<p>Fedora configuration not yet loaded</p>";
    private boolean configured = false;
    private boolean connected = false;
    public static final Property FILE_NAME = ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/fedora/0.1#fileName");
    public static final Property CONTENT_TYPE = ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/fedora/0.1#contentType");
    public static final Property FILE_LOCATION = ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#fileLocation");
    DateTimeFormatter isoFormatter = ISODateTimeFormat.dateTime();
    private static Log log = LogFactory.getLog(FedoraConfiguration.class);
    private static final String RELOAD_MSG = "<p>The fedora configuartion file will be reloaded if you edit the properties file and check the status.</p>\n";

    public FedoraConfiguration(ServletContext context) {
        this.setup(context);
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String setup(ServletContext context) {
        this.internalSetup(context);
        if (!this.configured) {
            return this.configurationStatus;
        }
        this.canConnectToFedoraServer();
        return this.configurationStatus;
    }

    private void internalSetup(ServletContext context) {
        this.configurationStatus = "";
        StringBuffer status = new StringBuffer("");
        if (this.connected && this.configured) {
            return;
        }
        Properties props = new Properties();
        String path = context.getRealPath(FEDORA_PROPERTIES);
        try {
            FileInputStream in = new FileInputStream(new File(path));
            props.load(in);
            this.fedoraUrl = props.getProperty("fedoraUrl");
            this.adminUser = props.getProperty("adminUser");
            this.adminPassword = props.getProperty("adminPassword");
            this.pidNamespace = props.getProperty("pidNamespace");
            if (this.fedoraUrl == null || this.adminUser == null || this.adminPassword == null) {
                if (this.fedoraUrl == null) {
                    log.error((Object)"'fedoraUrl' not found in properties file");
                    status.append("<p>'fedoraUrl' not found in properties file.</p>\n");
                }
                if (this.adminUser == null) {
                    log.error((Object)"'adminUser' was not found in properties file, the user name of the fedora admin is needed to access the fedora API-M services.");
                    status.append("<p>'adminUser' was not found in properties file, the user name of the fedora admin is needed to access the fedora API-M services.</p>\n");
                }
                if (this.adminPassword == null) {
                    log.error((Object)"'adminPassword' was not found in properties file, the admin password is needed to access the fedora API-M services.");
                    status.append("<p>'adminPassword' was not found in properties file, the admin password is needed to access the fedora API-M services.</p>\n");
                }
                if (this.pidNamespace == null) {
                    log.error((Object)"'pidNamespace' was not found in properties file, the PID namespace indicates which namespace to use when creating new fedor digital objects.");
                    status.append("<p>'pidNamespace' was not found in properties file, the PID namespace indicates which namespace to use when creating new fedor digital objects.</p>\n");
                }
                this.fedoraUrl = null;
                this.adminUser = null;
                this.adminPassword = null;
                this.configured = false;
            } else {
                this.configured = true;
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("No fedora.properties file found,it should be located at " + path));
            status.append("<h1>Fedora configuration failed.</h1>\n");
            status.append("<p>No fedora.properties file found,it should be located at " + path + "</p>\n");
            this.configured = false;
            return;
        }
        catch (Exception ex) {
            status.append("<p>Fedora configuration failed.</p>\n");
            status.append("<p>Exception while loading" + path + "</p>\n");
            status.append("<p>" + ex.getMessage() + "</p>\n");
            log.error((Object)"could not load fedora properties", (Throwable)ex);
            this.fedoraUrl = null;
            this.adminUser = null;
            this.adminPassword = null;
            this.configured = false;
            return;
        }
        status.append(RELOAD_MSG);
        this.configurationStatus = this.configurationStatus + status.toString();
    }

    public boolean canConnectToFedoraServer() {
        try {
            FedoraClient fc = new FedoraClient(this.fedoraUrl, this.adminUser, this.adminPassword);
            String fedoraVersion = fc.getServerVersion();
            if (fedoraVersion != null && fedoraVersion.length() > 0) {
                this.configurationStatus = this.configurationStatus + "<p>Fedora server is live and is running fedora version " + fedoraVersion + "</p>\n";
                this.connected = true;
                return true;
            }
            this.configurationStatus = this.configurationStatus + "<p>Unable to reach fedora server</p>\n";
            this.connected = false;
            return false;
        }
        catch (Exception e) {
            this.configurationStatus = this.configurationStatus + "<p>There was an error while checking the fedora server version</p>\n<p>" + e.getMessage() + "</p>\n";
            this.connected = false;
            return false;
        }
    }

    public String getFedoraUrl() {
        return this.fedoraUrl;
    }

    public void setFedoraUrl(String fedoraUrl) {
        this.fedoraUrl = fedoraUrl;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public void setAdminUser(String adminUser) {
        this.adminUser = adminUser;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getPidNamespace() {
        return this.pidNamespace;
    }

    public void setPidNamespace(String pidNamespace) {
        this.pidNamespace = pidNamespace;
    }

    public String getConfigurationStatus() {
        return this.configurationStatus;
    }

    public void setConfigurationStatus(String configurationStatus) {
        this.configurationStatus = configurationStatus;
    }
}

