/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import java.util.Enumeration;
import java.util.Iterator;

public class IterableAdaptor<T>
implements Iterable<T> {
    private final Enumeration<T> en;
    private final Iterator<T> it;

    public IterableAdaptor(Enumeration<T> en) {
        this.en = en;
        this.it = null;
    }

    public IterableAdaptor(Iterator<T> it) {
        this.it = it;
        this.en = null;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.en != null) {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return IterableAdaptor.this.en.hasMoreElements();
                }

                @Override
                public T next() {
                    return IterableAdaptor.this.en.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (this.it != null) {
            return this.it;
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterable<T> adapt(Enumeration<T> enin) {
        return new IterableAdaptor<T>(enin);
    }

    public static <T> Iterable<T> adapt(Iterator<T> itin) {
        return new IterableAdaptor<T>(itin);
    }
}

