/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class JsonToFmModel {
    public static String ROOT_ARRAY = "root";

    public static Map<String, Object> convertJSONObjectToMap(String jsonString) throws JSONException {
        JSONObject jo = new JSONObject(new JSONTokener(jsonString));
        return JsonToFmModel.convertJSONObjectToMap(jo);
    }

    public static Map<String, Object> convertJSONObjectToMap(JSONObject jo) throws JSONException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Iterator itr = jo.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object o = jo.get(key);
            if (o instanceof JSONObject) {
                model.put(key, JsonToFmModel.convertJSONObjectToMap((JSONObject)o));
                continue;
            }
            if (o instanceof JSONArray) {
                model.put(key, JsonToFmModel.convertJSONArrayToList((JSONArray)o));
                continue;
            }
            if (o == JSONObject.NULL) {
                model.put(key, null);
                continue;
            }
            model.put(key, o);
        }
        return model;
    }

    public static Map<String, Object> convertJSONArrayToMap(String jsonString) throws JSONException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        JSONArray ja = new JSONArray(new JSONTokener(jsonString));
        model.put(ROOT_ARRAY, JsonToFmModel.convertJSONArrayToList(ja));
        return model;
    }

    public static List<Object> convertJSONArrayToList(JSONArray ja) throws JSONException {
        ArrayList<Object> model = new ArrayList<Object>();
        for (int i = 0; i < ja.length(); ++i) {
            Object o = ja.get(i);
            if (o instanceof JSONArray) {
                model.add(JsonToFmModel.convertJSONArrayToList((JSONArray)o));
                continue;
            }
            if (o instanceof JSONObject) {
                model.add(JsonToFmModel.convertJSONObjectToMap((JSONObject)o));
                continue;
            }
            if (o == JSONObject.NULL) {
                model.add(null);
                continue;
            }
            model.add(o);
        }
        return model;
    }

    public static String toString(Map<String, Object> map) {
        return JsonToFmModel.toStringBuffer(map, 0).toString();
    }

    private static StringBuffer toStringBuffer(Map<String, Object> unsortedMap, int indent) {
        StringBuffer tabs = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            tabs.append("\t");
        }
        StringBuffer sb = new StringBuffer();
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.putAll(unsortedMap);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                sb.append(tabs).append((String)entry.getKey()).append(":").append(entry.getValue().getClass()).append("\n");
                sb.append(JsonToFmModel.toStringBuffer((Map)entry.getValue(), indent + 1));
                continue;
            }
            if (entry.getValue() instanceof List) {
                sb.append(tabs).append("[\n");
                List l = (List)entry.getValue();
                for (int i = 0; i < l.size(); ++i) {
                    sb.append(tabs).append(l.get(i)).append(":").append(l.get(i) != null ? l.get(i).getClass() : "null").append("\n");
                }
                sb.append(tabs).append("]\n");
                continue;
            }
            sb.append(tabs).append((String)entry.getKey()).append(":").append(entry.getValue()).append(":").append(entry.getValue() != null ? entry.getValue().getClass() : "null").append("\n");
        }
        return sb;
    }
}

