/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.tidy.Tidy;

public class MakeTidy {
    private static final Log log = LogFactory.getLog(MakeTidy.class);
    private static PrintWriter outFile = new PrintWriter(new LoggingWriter(log));

    public String process(String value) {
        Tidy tidy = new Tidy();
        tidy.setAsciiChars(true);
        tidy.setDropEmptyParas(true);
        tidy.setDropFontTags(true);
        tidy.setDropProprietaryAttributes(true);
        tidy.setForceOutput(true);
        tidy.setLogicalEmphasis(true);
        tidy.setMakeBare(true);
        tidy.setMakeClean(true);
        tidy.setPrintBodyOnly(true);
        tidy.setShowWarnings(true);
        tidy.setTidyMark(true);
        tidy.setTrimEmptyElements(true);
        tidy.setWord2000(true);
        tidy.setXHTML(true);
        tidy.setErrout(outFile);
        tidy.setShowErrors(Integer.MAX_VALUE);
        outFile.println("\nInput:\n" + value + "\n");
        StringWriter sw = new StringWriter();
        tidy.parse((Reader)new StringReader(value), (Writer)sw);
        String outputStr = sw.toString();
        log.debug((Object)("\nTidied Output:\n" + outputStr + "\n"));
        return outputStr;
    }

    private static class LoggingWriter
    extends Writer {
        private final Log logger;
        private String buffer;

        LoggingWriter(Log logger) {
            this.logger = logger;
            this.buffer = "";
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.buffer = this.buffer + new String(cbuf, off, len);
            this.dumpLines();
        }

        @Override
        public void close() throws IOException {
            if (this.buffer.length() > 0) {
                this.buffer = this.buffer + "\n";
                this.dumpLines();
            }
        }

        @Override
        public void flush() throws IOException {
        }

        private void dumpLines() {
            int lineEnd;
            while ((lineEnd = this.buffer.indexOf("\n")) != -1) {
                this.logger.info((Object)this.buffer.substring(0, lineEnd).trim());
                this.buffer = this.buffer.substring(lineEnd + 1);
            }
            return;
        }
    }
}

