/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.PropertyType;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.WrappedInstance;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InstanceWrapper {
    public static <T> WrappedInstance<T> wrap(Class<? extends T> concreteClass) throws InstanceWrapperException {
        return new WrappedInstance<T>(InstanceWrapper.createInstance(concreteClass), InstanceWrapper.parsePropertyAnnotations(concreteClass), InstanceWrapper.parseValidationAnnotations(concreteClass));
    }

    private static <T> T createInstance(Class<? extends T> concreteClass) throws InstanceWrapperException {
        try {
            return concreteClass.newInstance();
        }
        catch (Exception e) {
            throw new InstanceWrapperException("Failed to create an instance.", e);
        }
    }

    private static Map<String, PropertyType.PropertyMethod> parsePropertyAnnotations(Class<?> concreteClass) throws InstanceWrapperException {
        HashMap<String, PropertyType.PropertyMethod> map = new HashMap<String, PropertyType.PropertyMethod>();
        for (Method method : concreteClass.getDeclaredMethods()) {
            Property annotation = method.getAnnotation(Property.class);
            if (annotation == null) continue;
            if (!method.getReturnType().equals(Void.TYPE)) {
                throw new InstanceWrapperException("Property method '" + method + "' should return void.");
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new InstanceWrapperException("Property method '" + method + "' must accept exactly one parameter.");
            }
            String uri = annotation.uri();
            if (map.containsKey(uri)) {
                throw new InstanceWrapperException("Two property methods have the same URI value: " + ((PropertyType.PropertyMethod)map.get(uri)).getMethod() + ", and " + method);
            }
            try {
                map.put(uri, PropertyType.createPropertyMethod(method));
            }
            catch (PropertyType.PropertyTypeException e) {
                throw new InstanceWrapperException("Failed to create the PropertyMethod", e);
            }
        }
        return map;
    }

    private static Set<Method> parseValidationAnnotations(Class<?> concreteClass) throws InstanceWrapperException {
        HashSet<Method> methods = new HashSet<Method>();
        for (Method method : concreteClass.getDeclaredMethods()) {
            if (method.getAnnotation(Validation.class) == null) continue;
            if (method.getParameterTypes().length > 0) {
                throw new InstanceWrapperException("Validation method '" + method + "' should not have parameters.");
            }
            if (!method.getReturnType().equals(Void.TYPE)) {
                throw new InstanceWrapperException("Validation method '" + method + "' should return void.");
            }
            methods.add(method);
        }
        return methods;
    }

    public static class InstanceWrapperException
    extends Exception {
        public InstanceWrapperException(String message) {
            super(message);
        }

        public InstanceWrapperException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

