/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonServlet;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupsForRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import edu.cornell.mannlib.vitro.webapp.utils.JsonToFmModel;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterBase;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.VClassGroupTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.VClassTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist.ListedIndividual;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist.ListedIndividualBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class BrowseDataGetter
extends DataGetterBase
implements DataGetter {
    static final Log log = LogFactory.getLog(BrowseDataGetter.class);
    String dataGetterURI;
    VitroRequest vreq;
    ServletContext context;
    protected static final Mode DEFAULT_MODE = Mode.ALL_CLASS_GROUPS;

    public BrowseDataGetter(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        this.configure(vreq, displayModel, dataGetterURI);
    }

    protected void configure(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        if (vreq == null) {
            throw new IllegalArgumentException("VitroRequest  may not be null.");
        }
        if (displayModel == null) {
            throw new IllegalArgumentException("Display Model may not be null.");
        }
        if (dataGetterURI == null) {
            throw new IllegalArgumentException("PageUri may not be null.");
        }
        this.vreq = vreq;
        this.context = vreq.getSession().getServletContext();
        this.dataGetterURI = dataGetterURI;
    }

    @Override
    public Map<String, Object> getData(Map<String, Object> pageData) {
        try {
            Map<String, String[]> params = this.vreq.getParameterMap();
            Mode mode = this.getMode(this.vreq, params);
            switch (mode) {
                case VCLASS_ALPHA: {
                    return this.doClassAlphaDisplay(params, this.vreq, this.context);
                }
                case CLASS_GROUP: {
                    return this.doClassGroupDisplay(params, this.vreq, this.context);
                }
                case VCLASS: {
                    return this.doClassDisplay(params, this.vreq, this.context);
                }
                case ALL_CLASS_GROUPS: {
                    return this.doAllClassGroupsDisplay(params, this.vreq, this.context);
                }
            }
            return this.doAllClassGroupsDisplay(params, this.vreq, this.context);
        }
        catch (Throwable th) {
            log.error((Object)th, th);
            return Collections.emptyMap();
        }
    }

    public String getType() {
        return "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#HomePage";
    }

    public String getDataServiceUrl() {
        return UrlBuilder.getUrl("/dataservice?getSearchIndividualsByVClass=1&vclassId=");
    }

    private Map<String, Object> doClassAlphaDisplay(Map params, VitroRequest request, ServletContext context) throws Exception {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.putAll(this.getCommonValues(context, request));
        body.putAll(this.getClassAlphaValues(params, request, context));
        return body;
    }

    private Map<String, Object> getClassAlphaValues(Map params, VitroRequest request, ServletContext context) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String classUri = BrowseDataGetter.getParam(Mode.VCLASS, request, params);
        VitroRequest vreq = new VitroRequest((HttpServletRequest)request);
        VClass vclass = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(classUri);
        map.put("class", new VClassTemplateModel(vclass));
        JSONObject vclassRes = JsonServlet.getSearchIndividualsByVClass(vclass.getURI(), (HttpServletRequest)request);
        map.put("totalCount", JsonToFmModel.convertJSONObjectToMap((String)vclassRes.get("totalCount")));
        map.put("alpha", JsonToFmModel.convertJSONObjectToMap((String)vclassRes.get("alpha")));
        map.put("individuals", JsonToFmModel.convertJSONArrayToList((JSONArray)vclassRes.get("individuals")));
        map.put("pages", JsonToFmModel.convertJSONArrayToList((JSONArray)vclassRes.get("pages")));
        map.put("letters", JsonToFmModel.convertJSONArrayToList((JSONArray)vclassRes.get("letters")));
        return map;
    }

    private Map<String, Object> getCommonValues(ServletContext context, VitroRequest vreq) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups((HttpServletRequest)vreq);
        List<VClassGroup> cgList = vcgc.getGroups();
        LinkedList<VClassGroupTemplateModel> cgtmList = new LinkedList<VClassGroupTemplateModel>();
        for (VClassGroup classGroup : cgList) {
            cgtmList.add(new VClassGroupTemplateModel(classGroup));
        }
        values.put("vClassGroups", cgtmList);
        return values;
    }

    protected Map<String, Object> doAllClassGroupsDisplay(Map params, VitroRequest request, ServletContext context) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.putAll(this.getCommonValues(context, request));
        body.putAll(this.getAllClassGroupData(request, params, context));
        return body;
    }

    protected Map<String, Object> getAllClassGroupData(VitroRequest request, Map params, ServletContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return map;
    }

    protected Map<String, Object> doClassDisplay(Map params, VitroRequest request, ServletContext context) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.putAll(this.getCommonValues(context, request));
        body.putAll(this.getClassData(request, params, context));
        return body;
    }

    private Map<String, Object> getClassData(VitroRequest request, Map params, ServletContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.getClassGroupData(request, params, context));
        String classUri = BrowseDataGetter.getParam(Mode.VCLASS, request, params);
        VitroRequest vreq = new VitroRequest((HttpServletRequest)request);
        VClass vclass = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(classUri);
        map.put("class", new VClassTemplateModel(vclass));
        List<Individual> inds = vreq.getWebappDaoFactory().getIndividualDao().getIndividualsByVClass(vclass);
        ArrayList<ListedIndividual> tInds = new ArrayList<ListedIndividual>(inds.size());
        for (Individual ind : inds) {
            tInds.add(ListedIndividualBuilder.build(ind, vreq));
        }
        map.put("individualsInClass", tInds);
        return map;
    }

    protected Map<String, Object> doClassGroupDisplay(Map params, VitroRequest request, ServletContext context) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.putAll(this.getCommonValues(context, request));
        body.putAll(this.getClassGroupData(request, params, context));
        return body;
    }

    protected Map<String, Object> getClassGroupData(VitroRequest request, Map params, ServletContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String vcgUri = BrowseDataGetter.getParam(Mode.CLASS_GROUP, request, params);
        VitroRequest vreq = new VitroRequest((HttpServletRequest)request);
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups((HttpServletRequest)request);
        VClassGroup vcg = vcgc.getGroup(vcgUri);
        ArrayList<VClassTemplateModel> classes = new ArrayList<VClassTemplateModel>(vcg.size());
        for (VClass vc : vcg) {
            classes.add(new VClassTemplateModel(vc));
        }
        map.put("classes", classes);
        map.put("classGroup", new VClassGroupTemplateModel(vcg));
        return map;
    }

    protected Mode getMode(VitroRequest request, Map<String, Object> params) {
        for (Mode mode : Mode.values()) {
            String param;
            String queryParam = request.getParameter(mode.param);
            if (queryParam != null && !queryParam.isEmpty()) {
                return mode;
            }
            Object obj = params.get(mode.param);
            String string = param = obj != null ? obj.toString() : null;
            if (param == null || param.isEmpty()) continue;
            return mode;
        }
        return DEFAULT_MODE;
    }

    public static String getParam(Mode mode, VitroRequest request, Map params) {
        if (request.getParameter(mode.param) != null) {
            return request.getParameter(mode.param);
        }
        if (params.get(mode.param) != null) {
            return params.get(mode.param).toString();
        }
        return null;
    }

    public JSONObject convertToJSON(Map<String, Object> dataMap, VitroRequest vreq) {
        JSONObject rObj = null;
        return rObj;
    }

    static enum Mode {
        VCLASS_ALPHA("vclassAlpha"),
        VCLASS("vclassUri"),
        CLASS_GROUP("classgroupUri"),
        ALL_CLASS_GROUPS("all");

        String param;

        private Mode(String param) {
            this.param = param;
        }
    }
}

