/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.IndividualListController;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.individuallist.IndividualListResults;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterBase;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.SearchQueryUtils;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist.ListedIndividual;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist.ListedIndividualBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchIndividualsDataGetter
extends DataGetterBase
implements DataGetter {
    String dataGetterURI;
    List<String> vclassUris = null;
    String saveToVar;
    VitroRequest vreq;
    ServletContext context;
    static final Log log = LogFactory.getLog(SearchIndividualsDataGetter.class);
    private static final String defaultTemplate = "menupage--defaultSearchIndividuals.ftl";
    private static final String saveToVarPropertyURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#saveToVar>";
    private static final String vclassIdPropertyURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#hasVClassId>";
    public static final String defaultVarNameForResults = "results";
    private static final String dataGetterQuery = "PREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nSELECT ?vclassUri ?saveToVar WHERE { \n  OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#saveToVar> ?saveToVar } \n   OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#hasVClassId> ?vclassUri } \n }";

    public SearchIndividualsDataGetter(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        this.configure(vreq, displayModel, dataGetterURI);
    }

    @Override
    public Map<String, Object> getData(Map<String, Object> pageData) {
        HashMap<String, String[]> merged = new HashMap<String, String[]>();
        merged.putAll(this.vreq.getParameterMap());
        for (String key : pageData.keySet()) {
            merged.put(key, new String[]{String.valueOf(pageData.get(key))});
        }
        return this.doSearchQuery(merged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        if (vreq == null) {
            throw new IllegalArgumentException("VitroRequest  may not be null.");
        }
        if (displayModel == null) {
            throw new IllegalArgumentException("Display Model may not be null.");
        }
        if (dataGetterURI == null) {
            throw new IllegalArgumentException("PageUri may not be null.");
        }
        this.vreq = vreq;
        this.context = vreq.getSession().getServletContext();
        this.dataGetterURI = dataGetterURI;
        this.vclassUris = new ArrayList<String>();
        QuerySolutionMap initBindings = new QuerySolutionMap();
        initBindings.add("dataGetterURI", (RDFNode)ResourceFactory.createResource((String)this.dataGetterURI));
        int count = 0;
        Query dataGetterConfigurationQuery = QueryFactory.create((String)dataGetterQuery);
        displayModel.enterCriticalSection(true);
        try {
            QueryExecution qexec = QueryExecutionFactory.create((Query)dataGetterConfigurationQuery, (Model)displayModel, (QuerySolution)initBindings);
            ResultSet res = qexec.execSelect();
            try {
                while (res.hasNext()) {
                    ++count;
                    QuerySolution soln = res.next();
                    Literal saveTo = soln.getLiteral("saveToVar");
                    this.saveToVar = saveTo != null && saveTo.isLiteral() ? saveTo.asLiteral().getLexicalForm() : defaultVarNameForResults;
                    String vclassUriStr = null;
                    Resource vclassUri = soln.getResource("vclassUri");
                    if (vclassUri != null && vclassUri.isResource()) {
                        vclassUriStr = vclassUri.getURI();
                    }
                    if (vclassUriStr == null) continue;
                    this.vclassUris.add(vclassUriStr);
                }
            }
            finally {
                qexec.close();
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }

    private Map<String, Object> doSearchQuery(Map<String, String[]> merged) {
        if (this.vclassUris.size() == 0) {
            if (merged.containsKey("vclassuri")) {
                this.vclassUris = Arrays.asList((Object[])merged.get("vclassuri"));
            } else {
                log.error((Object)"No vclass uri found.  Search query will not work");
            }
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (this.vclassUris.size() > 0) {
            String title;
            String vClassURI = this.vclassUris.get(0);
            VClass vclass = this.vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(vClassURI);
            if (vclass == null) {
                log.error((Object)("Couldn't retrieve vclass " + vClassURI));
            }
            String vclassUri = vclass.getURI();
            body.put("vclassId", vclassUri);
            this.vreq.setAttribute("displayType", vclassUri);
            VClassGroup classGroup = vclass.getGroup();
            if (classGroup == null) {
                title = vclass.getName();
            } else {
                title = classGroup.getPublicName();
                body.put("subtitle", vclass.getName());
            }
            body.put("title", title);
            this.populateSearchQueryResults(vclass, body);
            body.put("bodyTemplate", defaultTemplate);
        } else {
            log.error((Object)"No VClass URIs found.  No query will be executed");
        }
        return body;
    }

    private void populateSearchQueryResults(VClass vclass, Map<String, Object> body) {
        try {
            String alpha = SearchQueryUtils.getAlphaParameter(this.vreq);
            int page = SearchQueryUtils.getPageParameter(this.vreq);
            IndividualListResults vcResults = IndividualListController.getResultsForVClass(vclass.getURI(), page, alpha, this.vreq.getWebappDaoFactory().getIndividualDao());
            body.putAll(vcResults.asFreemarkerMap());
            List<Individual> inds = vcResults.getEntities();
            ArrayList<ListedIndividual> indsTm = new ArrayList<ListedIndividual>();
            if (inds != null) {
                for (Individual ind : inds) {
                    indsTm.add(ListedIndividualBuilder.build(ind, this.vreq));
                }
            }
            body.put("individuals", indsTm);
            body.put("rdfUrl", UrlBuilder.getUrl("/listrdf", "vclass", vclass.getURI()));
        }
        catch (IndividualListController.SearchException ex) {
            log.error((Object)"Error retrieving results for display.", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred in retrieving results ", (Throwable)ex);
        }
    }
}

