/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SparqlQueryDataGetter
extends DataGetterBase
implements DataGetter {
    private static final Log log = LogFactory.getLog(SparqlQueryDataGetter.class);
    private static final String queryPropertyURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#query>";
    private static final String saveToVarPropertyURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#saveToVar>";
    private static final String queryModelPropertyURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#queryModel>";
    public static final String defaultVarNameForResults = "results";
    private static final String defaultTemplate = "menupage--defaultSparql.ftl";
    String dataGetterURI;
    String queryText;
    String saveToVar;
    String modelURI;
    VitroRequest vreq;
    ServletContext context;
    private static final String dataGetterQuery = "PREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nSELECT ?query ?saveToVar ?queryModel WHERE { \n  ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#query> ?query . \n  OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#saveToVar> ?saveToVar } \n   OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#queryModel> ?queryModel } \n}";

    public SparqlQueryDataGetter(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        this.configure(vreq, displayModel, dataGetterURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        if (vreq == null) {
            throw new IllegalArgumentException("VitroRequest  may not be null.");
        }
        if (displayModel == null) {
            throw new IllegalArgumentException("Display Model may not be null.");
        }
        if (dataGetterURI == null) {
            throw new IllegalArgumentException("PageUri may not be null.");
        }
        this.vreq = vreq;
        this.context = vreq.getSession().getServletContext();
        this.dataGetterURI = dataGetterURI;
        QuerySolutionMap initBindings = new QuerySolutionMap();
        initBindings.add("dataGetterURI", (RDFNode)ResourceFactory.createResource((String)this.dataGetterURI));
        Query dataGetterConfigurationQuery = QueryFactory.create((String)dataGetterQuery);
        displayModel.enterCriticalSection(true);
        try {
            QueryExecution qexec = QueryExecutionFactory.create((Query)dataGetterConfigurationQuery, (Model)displayModel, (QuerySolution)initBindings);
            ResultSet res = qexec.execSelect();
            try {
                while (res.hasNext()) {
                    QuerySolution soln = res.next();
                    Literal value = soln.getLiteral("query");
                    if (dataGetterConfigurationQuery == null) {
                        log.error((Object)("no query defined for page " + this.dataGetterURI));
                    } else {
                        this.queryText = value.getLexicalForm();
                    }
                    RDFNode node = soln.get("queryModel");
                    this.modelURI = node != null && node.isURIResource() ? node.asResource().getURI() : (node != null && node.isLiteral() ? node.asLiteral().getLexicalForm() : null);
                    Literal saveTo = soln.getLiteral("saveToVar");
                    if (saveTo != null && saveTo.isLiteral()) {
                        this.saveToVar = saveTo.asLiteral().getLexicalForm();
                        continue;
                    }
                    this.saveToVar = defaultVarNameForResults;
                }
            }
            finally {
                qexec.close();
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }

    @Override
    public Map<String, Object> getData(Map<String, Object> pageData) {
        Map<String, String> merged = this.mergeParameters(this.vreq.getParameterMap(), pageData);
        String boundQueryText = this.bindParameters(this.queryText, merged);
        if (this.modelURI != null) {
            return this.doQueryOnModel(boundQueryText, this.getModel(this.context, this.vreq, this.modelURI));
        }
        return this.doQueryOnRDFService(boundQueryText);
    }

    private Map<String, String> mergeParameters(Map<String, String[]> parameterMap, Map<String, Object> pageData) {
        HashMap<String, String> merged = new HashMap<String, String>();
        for (String key : parameterMap.keySet()) {
            merged.put(key, parameterMap.get(key)[0]);
        }
        for (String key : pageData.keySet()) {
            merged.put(key, String.valueOf(pageData.get(key)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Merging request parameters " + parameterMap + " with page data " + pageData + " results in " + merged));
        }
        return merged;
    }

    private String bindParameters(String text, Map<String, String> merged) {
        String bound = text;
        for (String key : merged.keySet()) {
            bound = bound.replaceAll("([?$]" + key + ")([^a-zA-Z0-9_\\-])", "<" + merged.get(key) + ">$2");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parameters: " + merged));
            log.debug((Object)("query before binding parameters:" + text));
            log.debug((Object)("query after binding parameters: " + bound));
        }
        return bound;
    }

    protected Map<String, Object> doQueryOnRDFService(String q) {
        log.debug((Object)("Going to RDFService with " + q));
        ResultSet results = QueryUtils.getQueryResults(q, this.vreq);
        return this.assembleMap(this.parseResults(results));
    }

    protected Map<String, Object> doQueryOnModel(String q, Model queryModel) {
        log.debug((Object)("Going to model " + this.modelURI + " with " + q));
        if (q == null) {
            return Collections.emptyMap();
        }
        Query query = this.makeQuery(q);
        if (query == null) {
            return Collections.emptyMap();
        }
        return this.assembleMap(this.executeQuery(query, queryModel));
    }

    private Query makeQuery(String q) {
        try {
            return QueryFactory.create((String)q);
        }
        catch (Exception e) {
            log.error((Object)"Failed to build a query from ''", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> executeQuery(Query query, Model model) {
        model.enterCriticalSection(true);
        try {
            List<Map<String, String>> list;
            QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);
            ResultSet results = qexec.execSelect();
            try {
                list = this.parseResults(results);
            }
            catch (Throwable throwable) {
                qexec.close();
                throw throwable;
            }
            qexec.close();
            return list;
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    private List<Map<String, String>> parseResults(ResultSet results) {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            rows.add(this.toRow(soln));
        }
        return rows;
    }

    private Map<String, String> toRow(QuerySolution soln) {
        HashMap<String, String> row = new HashMap<String, String>();
        Iterator varNames = soln.varNames();
        while (varNames.hasNext()) {
            String varname = (String)varNames.next();
            row.put(varname, this.toCell(soln.get(varname)));
        }
        return row;
    }

    private String toCell(RDFNode rdfNode) {
        if (rdfNode == null) {
            return "";
        }
        if (rdfNode.isLiteral()) {
            return rdfNode.asLiteral().getLexicalForm();
        }
        if (rdfNode.isResource()) {
            Resource resource = (Resource)rdfNode;
            if (!resource.isAnon()) {
                return resource.getURI();
            }
            return resource.getId().getLabelString();
        }
        return rdfNode.toString();
    }

    private Map<String, Object> assembleMap(List<Map<String, String>> results) {
        HashMap<String, Object> rmap = new HashMap<String, Object>();
        rmap.put(this.saveToVar, results);
        rmap.put("variableName", this.saveToVar);
        rmap.put("bodyTemplate", defaultTemplate);
        return rmap;
    }
}

