/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.developer;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeveloperSettings {
    private static final Log log = LogFactory.getLog(DeveloperSettings.class);
    private static final DeveloperSettings instance = new DeveloperSettings();
    private final Map<Key, String> settings = new EnumMap<Key, String>(Key.class);

    public static DeveloperSettings getInstance() {
        return instance;
    }

    private DeveloperSettings() {
    }

    public void updateFromRequest(Map<String, String[]> parameterMap) {
        if (log.isDebugEnabled()) {
            this.dumpParameterMap(parameterMap);
        }
        HashMap<Key, String> fromRequest = new HashMap<Key, String>();
        for (String key : parameterMap.keySet()) {
            fromRequest.put(Key.fromElementId(key), parameterMap.get(key)[0]);
        }
        this.update(fromRequest);
    }

    public void updateFromProperties(Properties properties) {
        HashMap<Key, String> fromFile = new HashMap<Key, String>();
        for (String key : properties.stringPropertyNames()) {
            fromFile.put(Key.fromPropertyName(key), properties.getProperty(key));
        }
        this.update(fromFile);
    }

    private void update(Map<Key, String> changedSettings) {
        for (Key key : Key.values()) {
            String s = changedSettings.get((Object)key);
            if (s == null) continue;
            s = s.trim();
            if (key.isBoolean()) {
                this.settings.put(key, Boolean.valueOf(s).toString());
                continue;
            }
            this.settings.put(key, s);
        }
        log.debug((Object)("DeveloperSettings: " + this));
    }

    public boolean getBoolean(Key key) {
        if (!key.isBoolean()) {
            log.warn((Object)("Key '" + (Object)((Object)key) + "' does not take a boolean value."));
        }
        if (this.isDeveloperModeEnabled()) {
            return Boolean.valueOf(this.settings.get((Object)key));
        }
        return false;
    }

    public String getString(Key key) {
        String value;
        if (key.isBoolean()) {
            log.warn((Object)("Key '" + (Object)((Object)key) + "' takes a boolean value."));
        }
        if ((value = this.settings.get((Object)key)) != null && this.isDeveloperModeEnabled()) {
            return value;
        }
        return "";
    }

    private boolean isDeveloperModeEnabled() {
        return Boolean.valueOf(this.settings.get((Object)Key.ENABLED));
    }

    public Map<String, Object> getRawSettingsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Key key : Key.values()) {
            map.put(key.elementId(), this.getRawValue(key));
        }
        return map;
    }

    private Object getRawValue(Key key) {
        String value = this.settings.get((Object)key);
        if (key.isBoolean()) {
            return Boolean.valueOf(value);
        }
        return value == null ? "" : value;
    }

    public String toString() {
        return "DeveloperSettings" + this.settings;
    }

    private void dumpParameterMap(Map<String, String[]> parameterMap) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (String key : parameterMap.keySet()) {
            map.put(key, Arrays.asList((Object[])parameterMap.get(key)));
        }
        log.debug((Object)("Parameter map: " + map));
    }

    public static class Setup
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            ServletContext ctx = sce.getServletContext();
            StartupStatus ss = StartupStatus.getBean(ctx);
            DeveloperSettings devSettings = DeveloperSettings.getInstance();
            Path homeDir = ApplicationUtils.instance().getHomeDirectory().getPath();
            File dsFile = homeDir.resolve("config/developer.properties").toFile();
            try (FileReader reader = new FileReader(dsFile);){
                Properties dsProps = new Properties();
                dsProps.load(reader);
                devSettings.updateFromProperties(dsProps);
                log.info((Object)devSettings);
                ss.info(this, "Loaded the 'developer.properties' file: " + devSettings);
            }
            catch (FileNotFoundException e) {
                ss.info(this, "'developer.properties' file does not exist.");
            }
            catch (Exception e) {
                ss.warning(this, "Failed to load the 'developer.properties' file.", e);
            }
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }
}

