/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.generators;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditModeUtils {
    private static Log log = LogFactory.getLog(EditModeUtils.class);

    public static FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq, List<String> possiblePredicates) {
        Individual object = EditConfigurationUtils.getObjectIndividual(vreq);
        boolean foundErrorMode = false;
        int numberEditModes = 0;
        int numberRepairModes = 0;
        int numberPredicates = possiblePredicates.size();
        for (String predicate : possiblePredicates) {
            FrontEndEditingUtils.EditMode mode = FrontEndEditingUtils.getEditMode((HttpServletRequest)vreq, object, predicate);
            log.debug((Object)("Checking edit mode for " + predicate + " and retrieved " + mode.toString()));
            if (mode == FrontEndEditingUtils.EditMode.ERROR) {
                log.debug((Object)("Edit mode is error for " + predicate));
                foundErrorMode = true;
                break;
            }
            if (mode == FrontEndEditingUtils.EditMode.EDIT) {
                log.debug((Object)("Edit mode is EDIT for " + predicate));
                ++numberEditModes;
                continue;
            }
            if (mode != FrontEndEditingUtils.EditMode.REPAIR) continue;
            log.debug((Object)("Edit mode is REPAIR for " + predicate));
            ++numberRepairModes;
        }
        log.debug((Object)("Number of edit editModes " + numberEditModes));
        log.debug((Object)("Number of repair editModes " + numberRepairModes));
        log.debug((Object)("Found error mode: " + foundErrorMode));
        if (foundErrorMode || numberEditModes > 1) {
            return FrontEndEditingUtils.EditMode.ERROR;
        }
        FrontEndEditingUtils.EditMode mode = FrontEndEditingUtils.EditMode.ADD;
        if (numberEditModes == 1) {
            mode = FrontEndEditingUtils.EditMode.EDIT;
        }
        if (numberRepairModes == numberPredicates) {
            mode = FrontEndEditingUtils.EditMode.REPAIR;
        }
        return mode;
    }

    public static boolean isAddMode(FrontEndEditingUtils.EditMode mode) {
        return mode == FrontEndEditingUtils.EditMode.ADD;
    }

    public static boolean isEditMode(FrontEndEditingUtils.EditMode mode) {
        return mode == FrontEndEditingUtils.EditMode.EDIT;
    }

    public static boolean isRepairMode(FrontEndEditingUtils.EditMode mode) {
        return mode == FrontEndEditingUtils.EditMode.REPAIR;
    }
}

