/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JenaIngestUtils {
    private static final Log log = LogFactory.getLog((String)JenaIngestUtils.class.getName());
    private Random random = new Random(System.currentTimeMillis());

    public Model renameBNodes(Model inModel, String namespaceEtc) {
        return this.renameBNodes(inModel, namespaceEtc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model renameBNodes(Model inModel, String namespaceEtc, Model dedupModel) {
        Model outModel = ModelFactory.createDefaultModel();
        OntModel dedupUnionModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        dedupUnionModel.addSubModel(outModel);
        if (dedupModel != null) {
            dedupUnionModel.addSubModel(dedupModel);
        }
        inModel.enterCriticalSection(true);
        HashSet<String> doneSet = new HashSet<String>();
        try {
            ResIterator it;
            outModel.add(inModel);
            try (ResIterator closeIt = inModel.listSubjects();){
                it = closeIt;
                while (it.hasNext()) {
                    Resource res = (Resource)it.next();
                    if (!res.isAnon() || doneSet.contains(res.getId())) continue;
                    Statement stmt = null;
                    try (StmtIterator closfIt = outModel.listStatements(res, (Property)null, (RDFNode)null);){
                        if (closfIt.hasNext()) {
                            stmt = (Statement)closfIt.next();
                        }
                    }
                    if (stmt == null) continue;
                    Resource outRes = stmt.getSubject();
                    ResourceUtils.renameResource((Resource)outRes, (String)this.getNextURI(namespaceEtc, (Model)dedupUnionModel));
                    doneSet.add(res.getId().toString());
                }
            }
            closeIt = inModel.listObjects();
            try {
                it = closeIt;
                while (it.hasNext()) {
                    Resource res;
                    RDFNode rdfn = (RDFNode)it.next();
                    if (!rdfn.isResource() || !(res = (Resource)rdfn).isAnon() || doneSet.contains(res.getId())) continue;
                    Statement stmt = null;
                    try (StmtIterator closfIt = outModel.listStatements((Resource)null, (Property)null, (RDFNode)res);){
                        if (closfIt.hasNext()) {
                            stmt = (Statement)closfIt.next();
                        }
                    }
                    if (stmt == null) continue;
                    Resource outRes = stmt.getSubject();
                    ResourceUtils.renameResource((Resource)outRes, (String)this.getNextURI(namespaceEtc, (Model)dedupUnionModel));
                    doneSet.add(res.getId().toString());
                }
            }
            finally {
                closeIt.close();
            }
        }
        finally {
            inModel.leaveCriticalSection();
        }
        return outModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model renameBNodesByPattern(Model inModel, String namespaceEtc, Model dedupModel, String pattern, String property) {
        Model outModel = ModelFactory.createDefaultModel();
        Property propertyRes = ResourceFactory.createProperty((String)property);
        OntModel dedupUnionModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        dedupUnionModel.addSubModel(outModel);
        if (dedupModel != null) {
            dedupUnionModel.addSubModel(dedupModel);
        }
        inModel.enterCriticalSection(true);
        HashSet<String> doneSet = new HashSet<String>();
        try {
            outModel.add(inModel);
            try (ResIterator closeIt = inModel.listSubjects();){
                ResIterator it = closeIt;
                while (it.hasNext()) {
                    Resource res = (Resource)it.next();
                    if (!res.isAnon() || doneSet.contains(res.getId())) continue;
                    Statement stmt = null;
                    try (StmtIterator closfIt = outModel.listStatements(res, propertyRes, (RDFNode)null);){
                        if (closfIt.hasNext()) {
                            stmt = (Statement)closfIt.next();
                        }
                    }
                    if (stmt == null) continue;
                    Resource outRes = stmt.getSubject();
                    if (stmt.getObject().isLiteral()) {
                        String value = ((Literal)stmt.getObject()).getLexicalForm();
                        String suffix = pattern.contains("$$$") ? pattern.replace("$$$", value) : pattern + value;
                        ResourceUtils.renameResource((Resource)outRes, (String)(namespaceEtc + suffix));
                    }
                    doneSet.add(res.getId().toString());
                }
            }
        }
        finally {
            inModel.leaveCriticalSection();
        }
        return outModel;
    }

    public Map<String, LinkedList<String>> generatePropertyMap(List<Model> sourceModels, ModelMaker maker) {
        Map<String, LinkedList<String>> propertyMap = Collections.synchronizedMap(new HashMap());
        HashSet<String> doneList = new HashSet<String>();
        for (Model model : sourceModels) {
            ResIterator cItr = model.listSubjects();
            while (cItr.hasNext()) {
                Resource res = (Resource)cItr.next();
                if (!res.isAnon() || doneList.contains(res.getId())) continue;
                doneList.add(res.getId().toString());
                StmtIterator stmtItr = model.listStatements(res, (Property)null, (RDFNode)null);
                while (stmtItr.hasNext()) {
                    LinkedList<String> linkList;
                    Statement stmt = (Statement)stmtItr.next();
                    if (stmt.getObject().isResource()) continue;
                    if (propertyMap.containsKey(stmt.getPredicate().getURI())) {
                        linkList = propertyMap.get(stmt.getPredicate().getURI());
                        linkList.add(stmt.getObject().toString());
                        continue;
                    }
                    propertyMap.put(stmt.getPredicate().getURI(), new LinkedList());
                    linkList = propertyMap.get(stmt.getPredicate().getURI());
                    linkList.add(stmt.getObject().toString());
                }
            }
            cItr = model.listObjects();
            while (cItr.hasNext()) {
                Resource res;
                RDFNode rdfn = (RDFNode)cItr.next();
                if (!rdfn.isResource() || !(res = (Resource)rdfn).isAnon() || doneList.contains(res.getId())) continue;
                doneList.add(res.getId().toString());
                StmtIterator stmtItr = model.listStatements(res, (Property)null, (RDFNode)null);
                while (stmtItr.hasNext()) {
                    LinkedList<String> linkList;
                    Statement stmt = (Statement)stmtItr.next();
                    if (stmt.getObject().isResource()) continue;
                    if (propertyMap.containsKey(stmt.getPredicate().getURI())) {
                        linkList = propertyMap.get(stmt.getPredicate().getURI());
                        linkList.add(stmt.getObject().toString());
                        continue;
                    }
                    propertyMap.put(stmt.getPredicate().getURI(), new LinkedList());
                    linkList = propertyMap.get(stmt.getPredicate().getURI());
                    linkList.add(stmt.getObject().toString());
                }
            }
            cItr.close();
        }
        return propertyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextURI(String namespaceEtc, Model model) {
        String nextURI = null;
        boolean duplicate = true;
        while (duplicate) {
            nextURI = namespaceEtc + this.random.nextInt(9999999);
            Resource res = ResourceFactory.createResource((String)nextURI);
            duplicate = false;
            try (StmtIterator closeIt = model.listStatements(res, (Property)null, (RDFNode)null);){
                if (closeIt.hasNext()) {
                    duplicate = true;
                }
            }
            if (duplicate) continue;
            closeIt = model.listStatements((Resource)null, (Property)null, (RDFNode)res);
            try {
                if (!closeIt.hasNext()) continue;
                duplicate = true;
            }
            finally {
                closeIt.close();
            }
        }
        return nextURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPropertyValueStrings(Model source, Model destination, Model additions, Model retractions, String processorClass, String processorMethod, String originalPropertyURI, String newPropertyURI) {
        block23: {
            Model additionsModel = ModelFactory.createDefaultModel();
            Model retractionsModel = ModelFactory.createDefaultModel();
            Class<?> stringProcessorClass = null;
            Object processor = null;
            Class[] methArgs = new Class[]{String.class};
            Method meth = null;
            try {
                stringProcessorClass = Class.forName(processorClass);
                processor = stringProcessorClass.newInstance();
                meth = stringProcessorClass.getMethod(processorMethod, methArgs);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                return;
            }
            Property prop = ResourceFactory.createProperty((String)originalPropertyURI);
            Property newProp = ResourceFactory.createProperty((String)newPropertyURI);
            source.enterCriticalSection(true);
            try {
                StmtIterator closeIt;
                StmtIterator stmtIt = closeIt = source.listStatements((Resource)null, prop, (RDFNode)null);
                while (stmtIt.hasNext()) {
                    Statement stmt = (Statement)stmtIt.next();
                    if (!stmt.getObject().isLiteral()) continue;
                    Literal lit = (Literal)stmt.getObject();
                    String lex = lit.getLexicalForm();
                    Object[] args = new Object[]{lex};
                    String newLex = null;
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("invoking string processor method on [" + lex.substring(0, lex.length() > 50 ? 50 : lex.length()) + "..."));
                        }
                        newLex = (String)meth.invoke(processor, args);
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                        source.leaveCriticalSection();
                        return;
                    }
                    if (newLex.equals(lex)) continue;
                    retractionsModel.add(stmt);
                    Literal newLit = null;
                    newLit = lit.getLanguage() != null && lit.getLanguage().length() > 0 ? additionsModel.createLiteral(newLex, lit.getLanguage()) : (lit.getDatatype() != null ? additionsModel.createTypedLiteral(newLex, lit.getDatatype()) : additionsModel.createLiteral(newLex));
                    additionsModel.add(stmt.getSubject(), newProp, (RDFNode)newLit);
                }
                if (destination != null) {
                    destination.enterCriticalSection(false);
                    try {
                        destination.add(additionsModel);
                        destination.remove(retractionsModel);
                    }
                    finally {
                        destination.leaveCriticalSection();
                    }
                }
                if (additions != null) {
                    additions.enterCriticalSection(false);
                    try {
                        additions.add(additionsModel);
                    }
                    finally {
                        additions.leaveCriticalSection();
                    }
                }
                if (retractions == null) break block23;
                retractions.enterCriticalSection(false);
                try {
                    retractions.add(retractionsModel);
                }
                finally {
                    retractions.leaveCriticalSection();
                }
            }
            finally {
                source.leaveCriticalSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model splitPropertyValues(Model inModel, String propertyURI, String splitRegex, String newPropertyURI, boolean trim) {
        Model outModel = ModelFactory.createDefaultModel();
        Pattern delimiterPattern = Pattern.compile(splitRegex);
        Property theProp = ResourceFactory.createProperty((String)propertyURI);
        Property newProp = ResourceFactory.createProperty((String)newPropertyURI);
        inModel.enterCriticalSection(true);
        try (StmtIterator stmtIt = inModel.listStatements((Resource)null, theProp, (RDFNode)null);){
            while (stmtIt.hasNext()) {
                Statement stmt = stmtIt.nextStatement();
                Resource subj = stmt.getSubject();
                RDFNode obj = stmt.getObject();
                if (!obj.isLiteral()) continue;
                Literal lit = (Literal)obj;
                String unsplitStr = lit.getLexicalForm();
                String[] splitPieces = delimiterPattern.split(unsplitStr);
                for (int i = 0; i < splitPieces.length; ++i) {
                    String newLexicalForm = splitPieces[i];
                    if (trim) {
                        newLexicalForm = newLexicalForm.trim();
                    }
                    if (newLexicalForm.length() <= 0) continue;
                    Literal newLiteral = null;
                    newLiteral = lit.getDatatype() != null ? outModel.createTypedLiteral(newLexicalForm, lit.getDatatype()) : (lit.getLanguage() != null ? outModel.createLiteral(newLexicalForm, lit.getLanguage()) : outModel.createLiteral(newLexicalForm));
                    outModel.add(subj, newProp, (RDFNode)newLiteral);
                }
            }
        }
        finally {
            inModel.leaveCriticalSection();
        }
        return outModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model smushResources(Model inModel, Property prop) {
        Model outModel = ModelFactory.createDefaultModel();
        outModel.add(inModel);
        inModel.enterCriticalSection(true);
        try (NodeIterator closeIt = inModel.listObjectsOfProperty(prop);){
            NodeIterator objIt = closeIt;
            while (objIt.hasNext()) {
                RDFNode rdfn = (RDFNode)objIt.next();
                try (ResIterator closfIt = inModel.listSubjectsWithProperty(prop, rdfn);){
                    boolean first = true;
                    Resource smushToThisResource = null;
                    ResIterator subjIt = closfIt;
                    while (closfIt.hasNext()) {
                        Statement stmt;
                        StmtIterator stmtIt;
                        Resource subj = (Resource)subjIt.next();
                        if (first) {
                            smushToThisResource = subj;
                            first = false;
                            continue;
                        }
                        try (StmtIterator closgIt = inModel.listStatements(subj, (Property)null, (RDFNode)null);){
                            stmtIt = closgIt;
                            while (stmtIt.hasNext()) {
                                stmt = (Statement)stmtIt.next();
                                outModel.remove(stmt.getSubject(), stmt.getPredicate(), stmt.getObject());
                                outModel.add(smushToThisResource, stmt.getPredicate(), stmt.getObject());
                            }
                        }
                        closgIt = inModel.listStatements((Resource)null, (Property)null, (RDFNode)subj);
                        try {
                            stmtIt = closgIt;
                            while (stmtIt.hasNext()) {
                                stmt = (Statement)stmtIt.next();
                                outModel.remove(stmt.getSubject(), stmt.getPredicate(), stmt.getObject());
                                outModel.add(stmt.getSubject(), stmt.getPredicate(), (RDFNode)smushToThisResource);
                            }
                        }
                        finally {
                            closgIt.close();
                        }
                    }
                }
            }
        }
        finally {
            inModel.leaveCriticalSection();
        }
        return outModel;
    }

    public Model dedupAndExtract(Model model, String preferredNamespace) {
        Model extractsModel = ModelFactory.createDefaultModel();
        HashMap<String, String> rewriteURIUsing = new HashMap<String, String>();
        ResIterator haveSameAsIt = model.listSubjectsWithProperty(OWL.sameAs);
        while (haveSameAsIt.hasNext()) {
            String preferredURI = null;
            Resource hasSameAs = (Resource)haveSameAsIt.next();
            List sameAsList = hasSameAs.listProperties(OWL.sameAs).toList();
            if (sameAsList.size() <= 1) continue;
            LinkedList<String> sameAsURIs = new LinkedList<String>();
            Iterator sameAsStmtIt = sameAsList.iterator();
            for (int i = 0; i < sameAsList.size(); ++i) {
                Statement sameAsStmt = (Statement)sameAsStmtIt.next();
                if (!sameAsStmt.getObject().isResource()) {
                    throw new RuntimeException(sameAsStmt.getResource().getURI() + " is sameAs() a literal!");
                }
                Resource sameAsRes = (Resource)sameAsStmt.getObject();
                if (!sameAsRes.isAnon()) {
                    sameAsURIs.add(sameAsRes.getURI());
                    if (preferredNamespace != null && preferredNamespace.equals(sameAsRes.getNameSpace())) {
                        preferredURI = sameAsRes.getURI();
                    }
                }
                if (preferredURI == null) {
                    preferredURI = (String)sameAsURIs.get(0);
                }
                for (String s : sameAsURIs) {
                    rewriteURIUsing.put(s, preferredURI);
                }
            }
        }
        StmtIterator modelStmtIt = model.listStatements();
        while (modelStmtIt.hasNext()) {
            String rewriteURI;
            Statement origStmt = modelStmtIt.nextStatement();
            Resource newSubj = null;
            RDFNode newObj = null;
            if (!origStmt.getSubject().isAnon() && (rewriteURI = (String)rewriteURIUsing.get(origStmt.getSubject().getURI())) != null) {
                newSubj = extractsModel.getResource(rewriteURI);
            }
            if (origStmt.getObject().isResource() && !origStmt.getResource().isAnon() && (rewriteURI = (String)rewriteURIUsing.get(((Resource)origStmt.getObject()).getURI())) != null) {
                newObj = extractsModel.getResource(rewriteURI);
            }
            if (newSubj == null) {
                newSubj = origStmt.getSubject();
            }
            if (newObj == null) {
                newObj = origStmt.getObject();
            }
            extractsModel.add(newSubj, origStmt.getPredicate(), newObj);
        }
        return extractsModel;
    }

    public OntModel generateTBox(Model abox) {
        OntModel tboxOntModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        StmtIterator sit = abox.listStatements();
        while (sit.hasNext()) {
            Statement stmt = sit.nextStatement();
            if (RDF.type.equals(stmt.getPredicate())) {
                this.makeClass(stmt.getObject(), tboxOntModel);
                continue;
            }
            if (stmt.getObject().isResource()) {
                this.makeObjectProperty(stmt.getPredicate(), tboxOntModel);
                continue;
            }
            if (!stmt.getObject().isLiteral()) continue;
            this.makeDatatypeProperty(stmt.getPredicate(), tboxOntModel);
        }
        return tboxOntModel;
    }

    private void makeClass(RDFNode node, OntModel tboxOntModel) {
        if (!node.isResource() || node.isAnon()) {
            return;
        }
        Resource typeRes = (Resource)node;
        if (tboxOntModel.getOntClass(typeRes.getURI()) == null) {
            tboxOntModel.createClass(typeRes.getURI());
        }
    }

    private void makeObjectProperty(Property property, OntModel tboxOntModel) {
        if (tboxOntModel.getObjectProperty(property.getURI()) == null) {
            tboxOntModel.createObjectProperty(property.getURI());
        }
    }

    private void makeDatatypeProperty(Property property, OntModel tboxOntModel) {
        if (tboxOntModel.getDatatypeProperty(property.getURI()) == null) {
            tboxOntModel.createDatatypeProperty(property.getURI());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeResult doMerge(String uri1, String uri2, OntModel baseOntModel, OntModel tboxOntModel, boolean usePrimaryLabelOnly) {
        boolean functionalPresent = false;
        Resource res1 = baseOntModel.getResource(uri1);
        Model res1Model = ModelFactory.createDefaultModel();
        Resource res2 = baseOntModel.getResource(uri2);
        Model res2Model = ModelFactory.createDefaultModel();
        baseOntModel.enterCriticalSection(true);
        try {
            res1Model.add(baseOntModel.listStatements(res1, (Property)null, (RDFNode)null));
            res2Model.add(baseOntModel.listStatements(res2, (Property)null, (RDFNode)null));
            res2Model.add(baseOntModel.listStatements((Resource)null, (Property)null, (RDFNode)res2));
        }
        finally {
            baseOntModel.leaveCriticalSection();
        }
        if (res1Model.isEmpty()) {
            return new MergeResult("resource 1 not present", null);
        }
        if (res2Model.isEmpty()) {
            return new MergeResult("resource 2 not present", null);
        }
        int counter = 0;
        Model leftoverModel = ModelFactory.createDefaultModel();
        StmtIterator stmtItr2 = res2Model.listStatements(res2, (Property)null, (RDFNode)null);
        while (stmtItr2.hasNext()) {
            Statement stmt = stmtItr2.nextStatement();
            if (this.isFunctional(stmt.getPredicate(), tboxOntModel)) {
                leftoverModel.add(res2, stmt.getPredicate(), stmt.getObject());
                functionalPresent = true;
                continue;
            }
            if (stmt.getPredicate().equals(RDFS.label) && usePrimaryLabelOnly) {
                leftoverModel.add(res2, stmt.getPredicate(), stmt.getObject());
                functionalPresent = true;
                continue;
            }
            baseOntModel.enterCriticalSection(false);
            try {
                baseOntModel.add(res1, stmt.getPredicate(), stmt.getObject());
                ++counter;
            }
            finally {
                baseOntModel.leaveCriticalSection();
            }
        }
        StmtIterator stmtItr3 = res2Model.listStatements((Resource)null, (Property)null, (RDFNode)res2);
        while (stmtItr3.hasNext()) {
            Statement stmt = stmtItr3.nextStatement();
            Resource sRes = stmt.getSubject();
            Property sProp = stmt.getPredicate();
            baseOntModel.enterCriticalSection(false);
            try {
                baseOntModel.add(sRes, sProp, (RDFNode)res1);
                ++counter;
            }
            finally {
                baseOntModel.leaveCriticalSection();
            }
        }
        baseOntModel.enterCriticalSection(false);
        try {
            baseOntModel.remove(res2Model);
        }
        finally {
            baseOntModel.leaveCriticalSection();
        }
        MergeResult result = new MergeResult();
        if (!leftoverModel.isEmpty()) {
            result.setLeftoverModel(leftoverModel);
        }
        if (counter > 0 && functionalPresent) {
            result.setResultText("merged " + counter + " statements. Some statements could not be merged.");
        } else if (counter > 0 && !functionalPresent) {
            result.setResultText("merged " + counter + " statements.");
        } else if (counter == 0) {
            result.setResultText("No statements merged");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFunctional(Property property, OntModel tboxOntModel) {
        tboxOntModel.enterCriticalSection(true);
        try {
            boolean bl = tboxOntModel.contains((Resource)property, RDF.type, (RDFNode)OWL.FunctionalProperty);
            return bl;
        }
        finally {
            tboxOntModel.leaveCriticalSection();
        }
    }

    public void doPermanentURI(String oldModel, String newModel, String oldNamespace, String newNamespace, ModelMaker maker, VitroRequest vreq) {
        if (newNamespace.isEmpty()) {
            throw new RuntimeException("new namespace must be specified");
        }
        WebappDaoFactory wdf = vreq.getUnfilteredWebappDaoFactory();
        Model m = maker.getModel(oldModel);
        Model saveModel = maker.getModel(newModel);
        Model tempModel = ModelFactory.createDefaultModel();
        ResIterator rsItr = null;
        ArrayList<String> urlCheck = new ArrayList<String>();
        boolean urlFound = false;
        if (!oldModel.equals(newModel)) {
            StmtIterator stmtItr = m.listStatements();
            while (stmtItr.hasNext()) {
                Statement stmt = stmtItr.nextStatement();
                tempModel.add(stmt);
            }
            rsItr = tempModel.listResourcesWithProperty((Property)null);
        } else {
            rsItr = m.listResourcesWithProperty((Property)null);
        }
        String uri = null;
        while (rsItr.hasNext()) {
            Resource res = (Resource)rsItr.next();
            if (!res.getNameSpace().equals(oldNamespace)) continue;
            do {
                if (urlCheck.contains(uri = this.getUnusedURI(newNamespace, wdf))) continue;
                urlCheck.add(uri);
                urlFound = true;
            } while (!urlFound);
            urlFound = false;
            ResourceUtils.renameResource((Resource)res, (String)uri);
        }
        boolean statementDone = false;
        if (!oldModel.equals(newModel)) {
            StmtIterator stmtItr = tempModel.listStatements();
            while (stmtItr.hasNext()) {
                statementDone = false;
                Statement stmt = stmtItr.nextStatement();
                Resource sRes = stmt.getSubject();
                Resource oRes = null;
                if (sRes.getNameSpace().equals(newNamespace)) {
                    saveModel.add(stmt);
                    statementDone = true;
                }
                try {
                    oRes = (Resource)stmt.getObject();
                    if (!oRes.getNameSpace().equals(newNamespace) || statementDone) continue;
                    saveModel.add(stmt);
                    statementDone = true;
                }
                catch (Exception e) {}
            }
        }
    }

    public String getUnusedURI(String newNamespace, WebappDaoFactory wdf) {
        String uri = null;
        String errMsg = null;
        Random random = new Random();
        boolean uriIsGood = false;
        for (int attempts = 0; !uriIsGood && attempts < 30; ++attempts) {
            uri = newNamespace + "n" + random.nextInt(Math.min(Integer.MAX_VALUE, (int)Math.pow(2.0, attempts + 13)));
            errMsg = wdf.checkURI(uri);
            if (errMsg != null) {
                uri = null;
                continue;
            }
            uriIsGood = true;
        }
        return uri;
    }

    public class MergeResult {
        private String resultText;
        private Model leftoverModel;

        public MergeResult() {
        }

        public MergeResult(String resultText, Model leftoverModel) {
            this.resultText = resultText;
            this.leftoverModel = leftoverModel;
        }

        public void setResultText(String resultText) {
            this.resultText = resultText;
        }

        public String getResultText() {
            return this.resultText;
        }

        public void setLeftoverModel(Model leftoverModel) {
            this.leftoverModel = leftoverModel;
        }

        public Model getLeftoverModel() {
            return this.leftoverModel;
        }
    }
}

