/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;

public class LogUtils {
    private final Log log;
    private final List<Object> dontFormatAgain = new ArrayList<Object>();

    public static String deepFormatForLog(Log log, String level, Object o) {
        if (!LogUtils.isLevelEnabled(log, level)) {
            return "";
        }
        return new LogUtils(log).deepFormat(o);
    }

    public static String formatRequestProperties(Log log, String level, HttpServletRequest req) {
        if (!LogUtils.isLevelEnabled(log, level)) {
            return "";
        }
        return new LogUtils(log).requestProperties(req);
    }

    private String requestProperties(HttpServletRequest req) {
        Map map = req.getParameterMap();
        String s = req.getRequestURL().append('\n').toString();
        for (String name : new TreeSet(map.keySet())) {
            s = s + "   " + name + " = " + Arrays.toString((Object[])map.get(name)) + '\n';
        }
        return s.trim();
    }

    private static boolean isLevelEnabled(Log log, String level) {
        if ("fatal".equalsIgnoreCase(level)) {
            return log.isFatalEnabled();
        }
        if ("error".equalsIgnoreCase(level)) {
            return log.isErrorEnabled();
        }
        if ("warn".equalsIgnoreCase(level)) {
            return log.isWarnEnabled();
        }
        if ("info".equalsIgnoreCase(level)) {
            return log.isInfoEnabled();
        }
        if ("debug".equalsIgnoreCase(level)) {
            return log.isDebugEnabled();
        }
        return log.isTraceEnabled();
    }

    private LogUtils(Log log) {
        this.log = log;
    }

    public String deepFormat(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (this.dontFormatAgain.contains(o)) {
            return "...";
        }
        this.dontFormatAgain.add(o);
        if (o instanceof Collection) {
            return this.formatCollection((Collection)o);
        }
        if (o instanceof Map) {
            return this.formatMap((Map)o);
        }
        if (o.getClass().isArray()) {
            return this.formatArray(o);
        }
        return this.formatObject(o);
    }

    private String formatClass(Object o) {
        if (o == null) {
            return "";
        }
        return o.getClass().getName();
    }

    private String formatCollection(Collection<?> collection) {
        StringBuilder result = new StringBuilder(this.formatClass(collection));
        result.append(": ");
        result.append('{');
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            result.append(this.deepFormat(it.next()));
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append('}');
        return result.toString();
    }

    private String formatMap(Map<?, ?> map) {
        StringBuilder result = new StringBuilder(this.formatClass(map));
        result.append(": ");
        result.append('{');
        Iterator<?> it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            result.append(this.deepFormat(key));
            result.append('=');
            result.append(this.deepFormat(map.get(key)));
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append('}');
        return result.toString();
    }

    private String formatArray(Object o) {
        return this.formatClass(o) + ": " + Arrays.deepToString((Object[])o);
    }

    private String formatObject(Object o) {
        String className = o.getClass().getName();
        String valueString = String.valueOf(o);
        if (valueString.contains(className)) {
            return valueString;
        }
        return this.formatClass(o) + ": " + valueString;
    }
}

