/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.menuManagement;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.ClassGroupPageData;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.utils.menuManagement.ProcessDataGetter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessClassGroup
implements ProcessDataGetter {
    private static final Log log = LogFactory.getLog(ProcessClassGroup.class);

    @Override
    public void populateTemplate(HttpServletRequest req, Map<String, Object> pageData, Map<String, Object> templateData) {
        templateData.put("isClassGroupPage", true);
        templateData.put("includeAllClasses", true);
        DataGetterUtils.getClassGroupForDataGetter(req, pageData, templateData);
    }

    @Override
    public Model processSubmission(VitroRequest vreq, Resource dataGetterResource) {
        Model dgModel = ModelFactory.createDefaultModel();
        String dataGetterTypeUri = DataGetterUtils.generateDataGetterTypeURI(ClassGroupPageData.class.getName());
        dgModel.add(dgModel.createStatement(dataGetterResource, RDF.type, (RDFNode)ResourceFactory.createResource((String)dataGetterTypeUri)));
        return dgModel;
    }
}

