/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.menuManagement;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.IndividualsForClassesDataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.menuManagement.ProcessDataGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessIndividualsForClasses
implements ProcessDataGetter {
    private static final Log log = LogFactory.getLog(ProcessIndividualsForClasses.class);

    @Override
    public void populateTemplate(HttpServletRequest req, Map<String, Object> pageData, Map<String, Object> templateData) {
        this.initTemplateData(templateData);
        this.populateIncludedClasses(pageData, templateData);
        this.populateRestrictedClasses(pageData, templateData);
        DataGetterUtils.getClassGroupForDataGetter(req, pageData, templateData);
    }

    protected void initTemplateData(Map<String, Object> templateData) {
        templateData.put("isIndividualsForClassesPage", true);
        templateData.put("isClassGroupPage", false);
        templateData.put("includeAllClasses", false);
    }

    protected void populateIncludedClasses(Map<String, Object> pageData, Map<String, Object> templateData) {
        VClassGroup includedClasses = (VClassGroup)pageData.get("vClassGroup");
        templateData.put("includeClasses", this.getClassUrisAsList(includedClasses));
    }

    protected void populateRestrictedClasses(Map<String, Object> pageData, Map<String, Object> templateData) {
        VClassGroup restrictedClasses = (VClassGroup)pageData.get("restrictVClassGroup");
        templateData.put("restricted", this.getClassUrisAsList(restrictedClasses));
    }

    protected List<String> getClassUrisAsList(VClassGroup includedClasses) {
        ArrayList<String> classUris = new ArrayList<String>();
        List<VClass> classList = includedClasses.getVitroClassList();
        for (VClass v : classList) {
            classUris.add(v.getURI());
        }
        return classUris;
    }

    public boolean useProcessor(VitroRequest vreq) {
        return !this.allClassesSelected(vreq);
    }

    @Override
    public Model processSubmission(VitroRequest vreq, Resource dataGetterResource) {
        String[] selectedClasses = vreq.getParameterValues("classInClassGroup");
        String dataGetterTypeUri = DataGetterUtils.generateDataGetterTypeURI(IndividualsForClassesDataGetter.class.getName());
        Model dgModel = ModelFactory.createDefaultModel();
        dgModel.add(dgModel.createStatement(dataGetterResource, RDF.type, (RDFNode)ResourceFactory.createResource((String)dataGetterTypeUri)));
        for (String classUri : selectedClasses) {
            dgModel.add(dgModel.createStatement(dataGetterResource, ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ontologies/display/1.1#getIndividualsForClass"), (RDFNode)ResourceFactory.createResource((String)classUri)));
        }
        return dgModel;
    }

    private boolean allClassesSelected(VitroRequest vreq) {
        String allClasses = vreq.getParameter("allSelected");
        return allClasses != null && !allClasses.isEmpty();
    }
}

