/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.searchengine;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.AutoCompleteWords;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.FieldMap;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.SearchResponseFilter;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.SearchResultsParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchQueryUtils {
    private static final Log log = LogFactory.getLog((String)SearchQueryUtils.class.getName());

    public static AutoCompleteWords parseForAutoComplete(String searchTerm, String delimiterPattern) {
        return new AutoCompleteWords(searchTerm, delimiterPattern);
    }

    public static FieldMap fieldMap() {
        return new FieldMap();
    }

    public static List<Map<String, String>> parseResponse(SearchResponse queryResponse, FieldMap fieldMap) {
        return new SearchResultsParser(queryResponse, fieldMap).parse();
    }

    public static List<Map<String, String>> parseAndFilterResponse(SearchResponse queryResponse, FieldMap fieldMap, SearchResponseFilter filter, int maxNumberOfResults) {
        return new SearchResultsParser(queryResponse, fieldMap).parseAndFilterResponse(filter, maxNumberOfResults);
    }

    public static List<String> parseWords(String typesString, String wordDelimiter) {
        String[] array;
        ArrayList<String> list = new ArrayList<String>();
        for (String word : array = typesString.split(wordDelimiter)) {
            String trimmed = word.trim();
            if (trimmed.isEmpty()) continue;
            list.add(trimmed);
        }
        return list;
    }

    public static String assembleConjunctiveQuery(String fieldName, Collection<String> words, Conjunction c) {
        ArrayList<String> terms = new ArrayList<String>();
        for (String word : words) {
            terms.add(SearchQueryUtils.buildTerm(fieldName, word));
        }
        return StringUtils.join(terms, (String)c.joiner());
    }

    private static String buildTerm(String fieldName, String word) {
        return fieldName + ":\"" + word + "\"";
    }

    public static String getAlphaParameter(VitroRequest request) {
        return request.getParameter("alpha");
    }

    public static int getPageParameter(VitroRequest request) {
        String pageStr = request.getParameter("page");
        if (pageStr != null) {
            try {
                return Integer.parseInt(pageStr);
            }
            catch (NumberFormatException nfe) {
                log.debug((Object)"could not parse page parameter");
                return 1;
            }
        }
        return 1;
    }

    public static long getIndividualCount(List<String> vclassUris) {
        SearchEngine search = ApplicationUtils.instance().getSearchEngine();
        SearchQuery query = search.createQuery(SearchQueryUtils.makeMultiClassQuery(vclassUris));
        query.setRows(0);
        try {
            SearchResponse response = null;
            response = search.query(query);
            return response.getResults().getNumFound();
        }
        catch (Exception ex) {
            log.error((Object)"An error occured in retrieving individual count", (Throwable)ex);
            return 0L;
        }
    }

    public static SearchQuery getQuery(List<String> vclassUris, String alpha, int page, int pageSize) {
        String queryText = "";
        SearchEngine searchEngine = ApplicationUtils.instance().getSearchEngine();
        try {
            queryText = SearchQueryUtils.makeMultiClassQuery(vclassUris);
            if (alpha != null && !"".equals(alpha) && alpha.length() == 1) {
                queryText = queryText + "nameLowercase:" + alpha.toLowerCase() + "*";
            }
            SearchQuery query = searchEngine.createQuery(queryText);
            int startRow = (page - 1) * pageSize;
            query.setStart(startRow).setRows(pageSize);
            query.addSortField("nameLowercaseSingleValued", SearchQuery.Order.ASC);
            log.debug((Object)("Query is " + query.toString()));
            return query;
        }
        catch (Exception ex) {
            log.error((Object)"Could not make the search query", (Throwable)ex);
            return searchEngine.createQuery();
        }
    }

    public static SearchQuery getRandomQuery(List<String> vclassUris, int page, int pageSize) {
        String queryText = "";
        SearchEngine searchEngine = ApplicationUtils.instance().getSearchEngine();
        try {
            queryText = SearchQueryUtils.makeMultiClassQuery(vclassUris);
            log.debug((Object)("queryText is " + queryText));
            SearchQuery query = searchEngine.createQuery(queryText);
            query.setStart(page).setRows(pageSize);
            log.debug((Object)("Query is " + query.toString()));
            return query;
        }
        catch (Exception ex) {
            log.error((Object)"Could not make the search query", (Throwable)ex);
            return searchEngine.createQuery();
        }
    }

    public static String makeMultiClassQuery(List<String> vclassUris) {
        ArrayList<String> queryTypes = new ArrayList<String>();
        try {
            for (String vclassUri : vclassUris) {
                queryTypes.add("type:\"" + vclassUri + "\" ");
            }
            return StringUtils.join(queryTypes, (String)" AND ");
        }
        catch (Exception ex) {
            log.error((Object)"Could not make the search query", (Throwable)ex);
            return "";
        }
    }

    public static enum Conjunction {
        AND,
        OR;


        public String joiner() {
            return " " + this.name() + " ";
        }
    }
}

