/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.searchengine;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocumentList;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.FieldMap;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.SearchResponseFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchResultsParser {
    private static final Log log = LogFactory.getLog(SearchResultsParser.class);
    private final SearchResponse queryResponse;
    private final Map<String, String> fieldNameMapping;

    public SearchResultsParser(SearchResponse queryResponse, FieldMap fieldMap) {
        this.queryResponse = queryResponse;
        this.fieldNameMapping = fieldMap.map();
    }

    public List<Map<String, String>> parse() {
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        if (this.queryResponse == null) {
            log.debug((Object)"Query response for a search was null");
            return maps;
        }
        SearchResultDocumentList docs = this.queryResponse.getResults();
        if (docs == null) {
            log.debug((Object)"Docs for a search was null");
            return maps;
        }
        log.debug((Object)("Total number of hits = " + docs.getNumFound()));
        for (SearchResultDocument doc : docs) {
            maps.add(this.parseSingleDocument(doc));
        }
        return maps;
    }

    public List<Map<String, String>> parseAndFilterResponse(SearchResponseFilter filter, int maxNumberOfResults) {
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        if (this.queryResponse == null) {
            log.debug((Object)"Query response for a search was null");
            return maps;
        }
        SearchResultDocumentList docs = this.queryResponse.getResults();
        if (docs == null) {
            log.debug((Object)"Docs for a search was null");
            return maps;
        }
        log.debug((Object)("Total number of hits = " + docs.getNumFound()));
        for (SearchResultDocument doc : docs) {
            Map<String, String> map = this.parseSingleDocument(doc);
            if (filter.accept(map)) {
                maps.add(map);
            }
            if (maps.size() < maxNumberOfResults) continue;
            break;
        }
        return maps;
    }

    private Map<String, String> parseSingleDocument(SearchResultDocument doc) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String searchResultFieldName : this.fieldNameMapping.keySet()) {
            String jsonFieldName = this.fieldNameMapping.get(searchResultFieldName);
            result.put(jsonFieldName, this.parseSingleValue(doc, searchResultFieldName));
        }
        return result;
    }

    private String parseSingleValue(SearchResultDocument doc, String key) {
        Object rawValue = doc.getFirstValue(key);
        if (rawValue == null) {
            return "";
        }
        if (rawValue instanceof String) {
            return (String)rawValue;
        }
        return String.valueOf(rawValue);
    }
}

