/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparql;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.SelectQueryHolder;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.SelectQueryRunner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RdfServiceQueryContext
implements SelectQueryRunner.SelectQueryContext {
    private static final Log log = LogFactory.getLog(RdfServiceQueryContext.class);
    private final RDFService rdfService;
    private final SelectQueryHolder query;

    RdfServiceQueryContext(RDFService rdfService, SelectQueryHolder query) {
        this.rdfService = rdfService;
        this.query = query;
    }

    @Override
    public RdfServiceQueryContext bindVariableToUri(String name, String uri) {
        return new RdfServiceQueryContext(this.rdfService, this.query.bindToUri(name, uri));
    }

    @Override
    public SelectQueryRunner.ExecutingSelectQueryContext execute() {
        return new RdfServiceExecutingQueryContext(this.rdfService, this.query);
    }

    private static class RdfServiceExecutingQueryContext
    implements SelectQueryRunner.ExecutingSelectQueryContext {
        private final RDFService rdfService;
        private final SelectQueryHolder query;

        public RdfServiceExecutingQueryContext(RDFService rdfService, SelectQueryHolder query) {
            this.rdfService = rdfService;
            this.query = query;
        }

        @Override
        public SelectQueryRunner.StringResultsMapping getStringFields(String ... names) {
            HashSet<String> fieldNames = new HashSet<String>(Arrays.asList(names));
            SelectQueryRunner.StringResultsMappingImpl mapping = new SelectQueryRunner.StringResultsMappingImpl();
            try {
                ResultSet results = RDFServiceUtils.sparqlSelectQuery(this.query.getQueryString(), this.rdfService);
                return this.mapResultsForQuery(results, fieldNames);
            }
            catch (Exception e) {
                log.error((Object)("problem while running query '" + this.query.getQueryString() + "'"), (Throwable)e);
                return mapping;
            }
        }

        private SelectQueryRunner.StringResultsMapping mapResultsForQuery(ResultSet results, Set<String> fieldNames) {
            SelectQueryRunner.StringResultsMappingImpl mapping = new SelectQueryRunner.StringResultsMappingImpl();
            while (results.hasNext()) {
                Map<String, String> rowMapping = this.mapResultsForRow(results.nextSolution(), fieldNames);
                if (rowMapping.isEmpty()) continue;
                mapping.add(rowMapping);
            }
            return mapping;
        }

        private Map<String, String> mapResultsForRow(QuerySolution row, Set<String> fieldNames) {
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator names = row.varNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                RDFNode node = row.get(name);
                String text = this.getTextForNode(node);
                if (!StringUtils.isNotBlank((String)text)) continue;
                map.put(name, text);
            }
            if (!fieldNames.isEmpty()) {
                map.keySet().retainAll(fieldNames);
            }
            return map;
        }

        private String getTextForNode(RDFNode node) {
            if (node == null) {
                return "";
            }
            if (node.isLiteral()) {
                return node.asLiteral().getString().trim();
            }
            return node.toString().trim();
        }
    }
}

