/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparql;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Iterator;

public class ResultSetIterators {

    private static class NodeConverter {
        private NodeConverter() {
        }

        public static Node toNode(RDFNode rdfNode) {
            if (rdfNode.isAnon()) {
                Resource a = rdfNode.asResource();
                return NodeFactory.createAnon((AnonId)a.getId());
            }
            if (rdfNode.isLiteral()) {
                Literal l = rdfNode.asLiteral();
                return NodeFactory.createLiteral((String)l.getLexicalForm(), (String)l.getLanguage(), (RDFDatatype)l.getDatatype());
            }
            return NodeFactory.createURI((String)rdfNode.asResource().getURI());
        }
    }

    public static class ResultSetTriplesIterator
    implements Iterator<Triple> {
        private final ResultSet resultSet;

        public ResultSetTriplesIterator(ResultSet resultSet) {
            this.resultSet = resultSet;
        }

        @Override
        public boolean hasNext() {
            return this.resultSet.hasNext();
        }

        @Override
        public Triple next() {
            QuerySolution s = this.resultSet.next();
            return new Triple(NodeConverter.toNode(s.get("s")), NodeConverter.toNode(s.get("p")), NodeConverter.toNode(s.get("o")));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ResultSetQuadsIterator
    implements Iterator<Quad> {
        private final ResultSet resultSet;

        public ResultSetQuadsIterator(ResultSet resultSet) {
            this.resultSet = resultSet;
        }

        @Override
        public boolean hasNext() {
            return this.resultSet.hasNext();
        }

        @Override
        public Quad next() {
            QuerySolution s = this.resultSet.next();
            return new Quad(NodeConverter.toNode(s.get("g")), NodeConverter.toNode(s.get("s")), NodeConverter.toNode(s.get("p")), NodeConverter.toNode(s.get("o")));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

