/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.directives;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.services.shortview.ShortViewService;
import edu.cornell.mannlib.vitro.webapp.services.shortview.ShortViewServiceSetup;
import edu.cornell.mannlib.vitro.webapp.web.directives.BaseTemplateDirectiveModel;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualShortViewDirective
extends BaseTemplateDirectiveModel {
    private static final Log log = LogFactory.getLog(IndividualShortViewDirective.class);

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String individualUri = this.getRequiredSimpleScalarParameter(params, "uri");
        Individual individual = this.getIndividual(individualUri);
        if (individual == null) {
            throw new TemplateModelException("Can't find individual for URI: \"" + individualUri + "\"");
        }
        String vcString = this.getRequiredSimpleScalarParameter(params, "viewContext");
        ShortViewService.ShortViewContext viewContext = ShortViewService.ShortViewContext.fromString(vcString);
        if (viewContext == null) {
            throw new TemplateModelException("viewContext must be one of these: " + ShortViewService.ShortViewContext.valueList());
        }
        this.renderShortView(individual, viewContext);
    }

    private Individual getIndividual(String individualUri) {
        Environment env = Environment.getCurrentEnvironment();
        HttpServletRequest request = (HttpServletRequest)env.getCustomAttribute("request");
        VitroRequest vreq = new VitroRequest(request);
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        IndividualDao iDao = wdf.getIndividualDao();
        return iDao.getIndividualByURI(individualUri);
    }

    private void renderShortView(Individual individual, ShortViewService.ShortViewContext svContext) {
        Environment env = Environment.getCurrentEnvironment();
        HttpServletRequest request = (HttpServletRequest)env.getCustomAttribute("request");
        ServletContext ctx = request.getSession().getServletContext();
        ShortViewService svs = ShortViewServiceSetup.getService(ctx);
        if (svs == null) {
            log.warn((Object)"ShortViewService was not initialized properly.");
            return;
        }
        ShortViewService.TemplateAndSupplementalData svInfo = svs.getShortViewInfo(individual, svContext, new VitroRequest(request));
        ObjectWrapper objectWrapper = env.getConfiguration().getObjectWrapper();
        for (String name : svInfo.getSupplementalData().keySet()) {
            Object value = svInfo.getSupplementalData().get(name);
            try {
                env.setVariable(name, objectWrapper.wrap(value));
            }
            catch (TemplateModelException e) {
                log.error((Object)("Failed to wrap supplemental data '" + name + "' = '" + value + "'"), (Throwable)e);
            }
        }
        try {
            Template template = env.getTemplateForInclusion(svInfo.getTemplateName(), null, true);
            env.include(template);
        }
        catch (IOException e) {
            log.error((Object)("Could not load template '" + svInfo.getTemplateName() + "': " + e));
            this.renderErrorMessage(individual);
        }
        catch (TemplateException e) {
            log.error((Object)("Could not process template '" + svInfo.getTemplateName() + "'"), (Throwable)e);
            this.renderErrorMessage(individual);
        }
    }

    private void renderErrorMessage(Individual individual) {
        Environment env = Environment.getCurrentEnvironment();
        try {
            env.getOut().append("<span>Can't process the custom short view for " + individual.getName() + "</span>");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> help(String name) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("effect", "Find the short view that applies to this individual in this context -- a template and optional DataGetters. Execute the DataGetters and render the template.");
        map.put("comments", "The path should be an absolute path, starting with \"/\".");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uri", "The URI of the individual being displayed.");
        params.put("viewContext", "One of these: " + ShortViewService.ShortViewContext.valueList());
        map.put("parameters", params);
        ArrayList<String> examples = new ArrayList<String>();
        examples.add("&lt;img src=\"<@shortView uri=individual.uri viewContext=\"SEARCH\" />\" /&gt;");
        map.put("examples", examples);
        return map;
    }
}

