/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.images;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlaceholderUtil {
    private static final Log log = LogFactory.getLog(PlaceholderUtil.class);
    private static final String ATTRIBUTE_NAME = PlaceholderUtil.class.getName();
    private static final String PROPERTIES_FILE_PATH = "/images/placeholders/placeholders.properties";
    private static final String DEFAULT_IMAGE_PATH = "/images/placeholders/thumbnail.jpg";
    private final Map<String, String> mapUrlsByClass;

    public static String getPlaceholderImagePathForType(VitroRequest vreq, String typeUri) {
        PlaceholderUtil pu = PlaceholderUtil.getPlaceholderUtil(vreq);
        if (pu == null) {
            return DEFAULT_IMAGE_PATH;
        }
        return pu.getPlaceholderImagePathForType(typeUri);
    }

    public static String getPlaceholderImagePathForIndividual(VitroRequest vreq, String individualUri) {
        PlaceholderUtil pu = PlaceholderUtil.getPlaceholderUtil(vreq);
        if (pu == null) {
            return DEFAULT_IMAGE_PATH;
        }
        IndividualDao iDao = vreq.getWebappDaoFactory().getIndividualDao();
        return pu.getPlaceholderImagePathForIndividual(iDao, individualUri);
    }

    private static PlaceholderUtil getPlaceholderUtil(VitroRequest vreq) {
        if (vreq == null) {
            return null;
        }
        ServletContext ctx = vreq.getSession().getServletContext();
        Object attrib = ctx.getAttribute(ATTRIBUTE_NAME);
        if (attrib instanceof PlaceholderUtil) {
            return (PlaceholderUtil)attrib;
        }
        log.warn((Object)("Looked for a PlaceholerUtil, but found " + attrib));
        return null;
    }

    private PlaceholderUtil(Map<String, String> map) {
        this.mapUrlsByClass = Collections.unmodifiableMap(new HashMap<String, String>(map));
    }

    private String getPlaceholderImagePathForType(String typeUri) {
        if (typeUri == null) {
            log.debug((Object)"getPlaceholderImagePathForType: typeUri is null");
            return DEFAULT_IMAGE_PATH;
        }
        String url = this.mapUrlsByClass.get(typeUri);
        if (url == null) {
            log.debug((Object)("getPlaceholderImagePathForType: no value for '" + typeUri + "'"));
            return DEFAULT_IMAGE_PATH;
        }
        log.debug((Object)("getPlaceholderImagePathForType: value for '" + typeUri + "' is '" + url + "'"));
        return url;
    }

    private String getPlaceholderImagePathForIndividual(IndividualDao iDao, String individualUri) {
        if (individualUri == null) {
            log.debug((Object)"getPlaceholderImagePathForIndividual: individualUri is null");
            return DEFAULT_IMAGE_PATH;
        }
        for (String classUri : this.mapUrlsByClass.keySet()) {
            String imageUrl = this.mapUrlsByClass.get(classUri);
            if (!iDao.isIndividualOfClass(classUri, individualUri)) continue;
            log.debug((Object)("getPlaceholderImagePathForIndividual: individual '" + individualUri + "' is of class '" + classUri + "', value is '" + imageUrl + "'"));
            return imageUrl;
        }
        log.debug((Object)("getPlaceholderImagePathForIndividual: individual '" + individualUri + "' is not of any recognized class"));
        return DEFAULT_IMAGE_PATH;
    }

    private static class SetupException
    extends Exception {
        public SetupException(String message) {
            super(message);
        }

        public SetupException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Setup
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            ServletContext ctx = sce.getServletContext();
            StartupStatus ss = StartupStatus.getBean(ctx);
            try {
                File propertiesFile = this.confirmRealPath(ctx, PlaceholderUtil.PROPERTIES_FILE_PATH);
                Map<String, String> map = this.loadPropertiesToMap(propertiesFile);
                this.confirmImagesArePresent(ctx, map);
                ctx.setAttribute(ATTRIBUTE_NAME, (Object)new PlaceholderUtil(map));
            }
            catch (SetupException e) {
                if (e.getCause() == null) {
                    ss.warning(this, e.getMessage());
                }
                ss.warning(this, e.getMessage(), e.getCause());
            }
        }

        private Map<String, String> loadPropertiesToMap(File propertiesFile) throws SetupException {
            Properties props = new Properties();
            try {
                props.load(new FileReader(propertiesFile));
            }
            catch (IOException e) {
                throw new SetupException("Can't load properties from the file at '/images/placeholders/placeholders.properties'. Is it in a valid format?", e);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = props.getProperty(key);
                map.put(key, value);
            }
            return map;
        }

        private void confirmImagesArePresent(ServletContext ctx, Map<String, String> map) throws SetupException {
            HashSet<String> imageUrls = new HashSet<String>();
            imageUrls.add(PlaceholderUtil.DEFAULT_IMAGE_PATH);
            imageUrls.addAll(map.values());
            for (String imageUrl : imageUrls) {
                this.confirmRealPath(ctx, imageUrl);
            }
        }

        private File confirmRealPath(ServletContext ctx, String url) throws SetupException {
            String path = ctx.getRealPath(url);
            if (path == null) {
                throw new SetupException("Can't translate to real path: '" + url + "'");
            }
            File file = new File(path);
            if (!file.exists()) {
                throw new SetupException("No file found at '" + url + "'.");
            }
            if (!file.canRead()) {
                throw new SetupException("Can't read the file at '" + url + "'.");
            }
            return file;
        }

        public void contextDestroyed(ServletContextEvent sce) {
            sce.getServletContext().removeAttribute(ATTRIBUTE_NAME);
        }
    }
}

