/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.jsptags;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.cornell.mannlib.vitro.webapp.utils.IterableAdaptor;
import java.util.HashMap;
import java.util.LinkedList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import net.djpowell.sparqltag.SelectTag;
import net.djpowell.sparqltag.SparqlTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListSparqlTag
extends SelectTag {
    private static final Log log = LogFactory.getLog(ListSparqlTag.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTag() throws JspException {
        log.debug((Object)"CollectionSparqlTag.doTag()");
        SparqlTag container = (SparqlTag)SimpleTagSupport.findAncestorWithClass((JspTag)this, SparqlTag.class);
        if (container == null) {
            throw new RuntimeException("Ancestor must be sparql container");
        }
        Query query = this.parseQuery();
        QueryExecution qex = QueryExecutionFactory.create((Query)query, (Model)this.model, (QuerySolution)this.qparams);
        log.debug((Object)"query executed");
        this.model.enterCriticalSection(true);
        try {
            ResultSet results = qex.execSelect();
            LinkedList resultList = new LinkedList();
            for (QuerySolution qs : IterableAdaptor.adapt(results)) {
                log.debug((Object)"found solution");
                HashMap<String, RDFNode> map1 = new HashMap<String, RDFNode>();
                for (String name : IterableAdaptor.adapt(qs.varNames())) {
                    RDFNode value = qs.get(name);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(name + ": " + value.toString()));
                    }
                    map1.put(name, value);
                }
                resultList.add(map1);
            }
            log.debug((Object)("setting " + this.var + " to a list of size " + resultList.size()));
            this.getJspContext().setAttribute(this.var, resultList);
        }
        finally {
            this.model.leaveCriticalSection();
            ListSparqlTag listSparqlTag = this;
            synchronized (listSparqlTag) {
                if (qex != null) {
                    qex.close();
                }
                this.model = null;
                this.var = null;
                this.qparams = null;
                qex = null;
            }
        }
    }
}

