/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayDataProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayObjectProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.DataPropertyTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.PropertyTemplateModel;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyGroupTemplateModel
extends BaseTemplateModel {
    private static final Log log = LogFactory.getLog(PropertyGroupTemplateModel.class);
    private final String name;
    private final List<PropertyTemplateModel> properties;

    PropertyGroupTemplateModel(VitroRequest vreq, PropertyGroup group, Individual subject, boolean editing, List<DataProperty> populatedDataPropertyList, List<ObjectProperty> populatedObjectPropertyList) {
        this.name = group.getName();
        List<Property> propertyList = group.getPropertyList();
        this.properties = new ArrayList<PropertyTemplateModel>(propertyList.size());
        for (Property p : propertyList) {
            if (p instanceof ObjectProperty) {
                ObjectPropertyTemplateModel tm;
                ObjectProperty op = (ObjectProperty)p;
                if (!this.allowedToDisplay(vreq, op, subject) || (tm = ObjectPropertyTemplateModel.getObjectPropertyTemplateModel(op, subject, vreq, editing, populatedObjectPropertyList)).isEmpty() && (!editing || tm.getAddUrl().isEmpty())) continue;
                this.properties.add(tm);
                continue;
            }
            if (p instanceof DataProperty) {
                DataProperty dp = (DataProperty)p;
                if (!this.allowedToDisplay(vreq, dp, subject)) continue;
                this.properties.add(new DataPropertyTemplateModel(dp, subject, vreq, editing, populatedDataPropertyList));
                continue;
            }
            log.debug((Object)(p.getURI() + " is neither an ObjectProperty nor a DataProperty; skipping display"));
        }
    }

    private boolean allowedToDisplay(VitroRequest vreq, ObjectProperty op, Individual subject) {
        DisplayObjectProperty dop = new DisplayObjectProperty(op);
        if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, new AuthorizationRequest[]{dop})) {
            return true;
        }
        DisplayObjectPropertyStatement dops = new DisplayObjectPropertyStatement(subject.getURI(), op, RequestedAction.SOME_URI);
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, new AuthorizationRequest[]{dops});
    }

    private boolean allowedToDisplay(VitroRequest vreq, DataProperty dp, Individual subject) {
        DisplayDataProperty dop = new DisplayDataProperty(dp);
        if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, new AuthorizationRequest[]{dop})) {
            return true;
        }
        DataPropertyStatementImpl dps = new DataPropertyStatementImpl(subject.getURI(), dp.getURI(), RequestedAction.SOME_LITERAL);
        DisplayDataPropertyStatement dops = new DisplayDataPropertyStatement(dps);
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, new AuthorizationRequest[]{dops});
    }

    protected boolean isEmpty() {
        return this.properties.isEmpty();
    }

    protected void remove(PropertyTemplateModel ptm) {
        this.properties.remove(ptm);
    }

    public String toString() {
        String ptmStr = "";
        for (int i = 0; i < this.properties.size(); ++i) {
            PropertyTemplateModel ptm = this.properties.get(i);
            String spacer = "\n  ";
            if (ptm == null) continue;
            ptmStr = ptmStr + spacer + ptm.toString();
        }
        return String.format("\nPropertyGroupTemplateModel %s[%s] ", this.name, ptmStr);
    }

    public String getName() {
        return this.name;
    }

    public String getName(String otherGroupName) {
        if (this.name == null || this.name.isEmpty()) {
            return otherGroupName;
        }
        return this.name;
    }

    public List<PropertyTemplateModel> getProperties() {
        return this.properties;
    }
}

