/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.widgets;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonServlet;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupsForRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import edu.cornell.mannlib.vitro.webapp.utils.JsonToFmModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.VClassGroupTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.VClassTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist.ListedIndividual;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist.ListedIndividualBuilder;
import edu.cornell.mannlib.vitro.webapp.web.widgets.Widget;
import freemarker.core.Environment;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class BrowseWidget
extends Widget {
    static final Log log = LogFactory.getLog(BrowseWidget.class);
    protected static final Mode DEFAULT_MODE = Mode.ALL_CLASS_GROUPS;

    @Override
    protected Widget.WidgetTemplateValues process(Environment env, Map params, HttpServletRequest request, ServletContext context) throws Exception {
        try {
            Mode mode = this.getMode(request, params);
            switch (mode) {
                case VCLASS_ALPHA: {
                    return this.doClassAlphaDisplay(env, params, request, context);
                }
                case CLASS_GROUP: {
                    return this.doClassGroupDisplay(env, params, request, context);
                }
                case VCLASS: {
                    return this.doClassDisplay(env, params, request, context);
                }
                case ALL_CLASS_GROUPS: {
                    return this.doAllClassGroupsDisplay(env, params, request, context);
                }
            }
            return this.doAllClassGroupsDisplay(env, params, request, context);
        }
        catch (Throwable th) {
            log.error((Object)th, th);
            return null;
        }
    }

    private Widget.WidgetTemplateValues doClassAlphaDisplay(Environment env, Map params, HttpServletRequest request, ServletContext context) throws Exception {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.putAll(this.getCommonValues(env, context));
        body.putAll(this.getClassAlphaValues(env, params, request, context));
        String macroName = Mode.VCLASS_ALPHA.macroName;
        return new Widget.WidgetTemplateValues(macroName, body);
    }

    private Map<String, Object> getClassAlphaValues(Environment env, Map params, HttpServletRequest request, ServletContext context) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String classUri = this.getParam(Mode.VCLASS, request, params);
        VitroRequest vreq = new VitroRequest(request);
        VClass vclass = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(classUri);
        map.put("class", new VClassTemplateModel(vclass));
        JSONObject vclassRes = JsonServlet.getSearchIndividualsByVClass(vclass.getURI(), request);
        map.put("totalCount", JsonToFmModel.convertJSONObjectToMap((String)vclassRes.get("totalCount")));
        map.put("alpha", JsonToFmModel.convertJSONObjectToMap((String)vclassRes.get("alpha")));
        map.put("individuals", JsonToFmModel.convertJSONArrayToList((JSONArray)vclassRes.get("individuals")));
        map.put("pages", JsonToFmModel.convertJSONArrayToList((JSONArray)vclassRes.get("pages")));
        map.put("letters", JsonToFmModel.convertJSONArrayToList((JSONArray)vclassRes.get("letters")));
        return map;
    }

    private Map<String, Object> getCommonValues(Environment env, ServletContext context) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        try {
            values.put("urls", env.getDataModel().get("urls"));
            values.put("currentServlet", env.getDataModel().get("currentServlet"));
        }
        catch (TemplateModelException e) {
            e.printStackTrace();
        }
        return values;
    }

    protected Widget.WidgetTemplateValues doAllClassGroupsDisplay(Environment env, Map params, HttpServletRequest request, ServletContext context) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.putAll(this.getCommonValues(env, context));
        body.putAll(this.getAllClassGroupData(request, params, context));
        String macroName = Mode.ALL_CLASS_GROUPS.macroName;
        return new Widget.WidgetTemplateValues(macroName, body);
    }

    protected Map<String, Object> getAllClassGroupData(HttpServletRequest request, Map params, ServletContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        VitroRequest vreq = new VitroRequest(request);
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups(request);
        List<VClassGroup> cgList = vcgc.getGroups();
        LinkedList<VClassGroupTemplateModel> cgtmList = new LinkedList<VClassGroupTemplateModel>();
        for (VClassGroup classGroup : cgList) {
            cgtmList.add(new VClassGroupTemplateModel(classGroup));
        }
        map.put("vclassGroupList", cgtmList);
        return map;
    }

    protected Widget.WidgetTemplateValues doClassDisplay(Environment env, Map params, HttpServletRequest request, ServletContext context) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.putAll(this.getCommonValues(env, context));
        body.putAll(this.getClassData(request, params, context));
        String macroName = Mode.VCLASS.macroName;
        return new Widget.WidgetTemplateValues(macroName, body);
    }

    private Map<String, Object> getClassData(HttpServletRequest request, Map params, ServletContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.getClassGroupData(request, params, context));
        String classUri = this.getParam(Mode.VCLASS, request, params);
        VitroRequest vreq = new VitroRequest(request);
        VClass vclass = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(classUri);
        map.put("class", new VClassTemplateModel(vclass));
        List<Individual> inds = vreq.getWebappDaoFactory().getIndividualDao().getIndividualsByVClass(vclass);
        ArrayList<ListedIndividual> tInds = new ArrayList<ListedIndividual>(inds.size());
        for (Individual ind : inds) {
            tInds.add(ListedIndividualBuilder.build(ind, vreq));
        }
        map.put("individualsInClass", tInds);
        return map;
    }

    protected Widget.WidgetTemplateValues doClassGroupDisplay(Environment env, Map params, HttpServletRequest request, ServletContext context) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.putAll(this.getCommonValues(env, context));
        body.putAll(this.getClassGroupData(request, params, context));
        String macroName = Mode.CLASS_GROUP.macroName;
        return new Widget.WidgetTemplateValues(macroName, body);
    }

    protected Map<String, Object> getClassGroupData(HttpServletRequest request, Map params, ServletContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String vcgUri = this.getParam(Mode.CLASS_GROUP, request, params);
        VitroRequest vreq = new VitroRequest(request);
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups(request);
        VClassGroup vcg = vcgc.getGroup(vcgUri);
        ArrayList<VClassTemplateModel> classes = new ArrayList<VClassTemplateModel>(vcg.size());
        for (VClass vc : vcg) {
            classes.add(new VClassTemplateModel(vc));
        }
        map.put("classes", classes);
        map.put("classGroup", new VClassGroupTemplateModel(vcg));
        map.put("classGroupName", vcg.getPublicName());
        map.put("classGroupUri", vcg.getURI());
        return map;
    }

    protected Mode getMode(HttpServletRequest request, Map params) {
        for (Mode mode : Mode.values()) {
            String param;
            String queryParam = request.getParameter(mode.param);
            if (queryParam != null && !queryParam.isEmpty()) {
                return mode;
            }
            Object obj = params.get(mode.param);
            String string = param = obj != null ? obj.toString() : null;
            if (param == null || param.isEmpty()) continue;
            return mode;
        }
        return DEFAULT_MODE;
    }

    protected String getParam(Mode mode, HttpServletRequest request, Map params) {
        if (request.getParameter(mode.param) != null) {
            return request.getParameter(mode.param);
        }
        if (params.get(mode.param) != null) {
            return params.get(mode.param).toString();
        }
        return null;
    }

    static enum Mode {
        VCLASS_ALPHA("vclassAlpha", "vclassAlpha"),
        VCLASS("vclass", "vclassUri"),
        CLASS_GROUP("classGroup", "classgroupUri"),
        ALL_CLASS_GROUPS("allClassGroups", "all");

        String macroName;
        String param;

        private Mode(String macroName, String param) {
            this.macroName = macroName;
            this.param = param;
        }
    }
}

