/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.vitro.opensocial;

import edu.ucsf.vitro.opensocial.GadgetViewRequirements;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;

public class GadgetSpec {
    private int appId = 0;
    private String name;
    private String openSocialGadgetURL;
    private List<String> channels = new ArrayList<String>();
    private Map<String, GadgetViewRequirements> viewRequirements = new HashMap<String, GadgetViewRequirements>();
    boolean enabled;
    private boolean unknownGadget = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GadgetSpec(int appId, String name, String openSocialGadgetURL, List<String> channels, BasicDataSource ds, boolean enabled, boolean unknownGadget) throws SQLException {
        this.appId = appId;
        this.name = name;
        this.openSocialGadgetURL = openSocialGadgetURL;
        this.channels.addAll(channels);
        this.enabled = enabled;
        this.unknownGadget = unknownGadget;
        if (!unknownGadget) {
            Connection conn = null;
            Statement stmt = null;
            ResultSet rset = null;
            try {
                String sqlCommand = "select page, viewer_req, owner_req, view, chromeId, opt_params, display_order from orng_app_views where appId = " + appId;
                conn = ds.getConnection();
                stmt = conn.createStatement();
                rset = stmt.executeQuery(sqlCommand);
                while (rset.next()) {
                    this.viewRequirements.put(rset.getString(1), new GadgetViewRequirements(rset.getString(1), rset.getString(2), rset.getString(3), rset.getString(4), rset.getString(5), rset.getString(6), rset.getInt(7)));
                }
            }
            finally {
                try {
                    rset.close();
                }
                catch (Exception exception) {}
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int getAppId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public String getGadgetURL() {
        return this.openSocialGadgetURL;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public boolean listensTo(String channel) {
        return this.unknownGadget || this.channels.contains(channel);
    }

    public GadgetViewRequirements getGadgetViewRequirements(String page) {
        if (this.viewRequirements.containsKey(page)) {
            return this.viewRequirements.get(page);
        }
        return null;
    }

    public boolean show(String viewerId, String ownerId, String page, BasicDataSource ds) throws SQLException {
        boolean show = true;
        if (this.viewRequirements.size() > 0) {
            show = false;
        }
        if (this.viewRequirements.containsKey(page)) {
            show = true;
            GadgetViewRequirements req = this.getGadgetViewRequirements(page);
            if ('U' == req.getViewerReq() && viewerId == null) {
                show = false;
            } else if ('R' == req.getViewerReq()) {
                show &= this.isRegisteredTo(viewerId, ds);
            }
            if ('R' == req.getOwnerReq()) {
                show &= this.isRegisteredTo(ownerId, ds);
            } else if ('S' == req.getOwnerReq()) {
                show &= viewerId == ownerId;
            }
        }
        return show;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegisteredTo(String personId, BasicDataSource ds) throws SQLException {
        int count = 0;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rset = null;
        try {
            String sqlCommand = "select count(*) from orng_app_registry where appId = " + this.getAppId() + " and personId = '" + personId + "';";
            conn = ds.getConnection();
            stmt = conn.createStatement();
            rset = stmt.executeQuery(sqlCommand);
            while (rset.next()) {
                count = rset.getInt(1);
            }
        }
        finally {
            try {
                rset.close();
            }
            catch (Exception exception) {}
            try {
                stmt.close();
            }
            catch (Exception exception) {}
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
        return count == 1;
    }

    public boolean fromSandbox() {
        return this.unknownGadget;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public char getVisibleScope() {
        GadgetViewRequirements req = this.getGadgetViewRequirements("/display");
        return req != null ? (char)req.getViewerReq() : (char)' ';
    }

    public String toString() {
        return "" + this.appId + ":" + this.name + ":" + this.openSocialGadgetURL;
    }
}

