/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.vitro.opensocial;

import edu.ucsf.vitro.opensocial.GadgetSpec;
import edu.ucsf.vitro.opensocial.GadgetViewRequirements;
import edu.ucsf.vitro.opensocial.OpenSocialManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class PreparedGadget
implements Comparable<PreparedGadget> {
    private GadgetSpec gadgetSpec;
    private OpenSocialManager helper;
    private int moduleId;
    private String securityToken;

    public PreparedGadget(GadgetSpec gadgetSpec, OpenSocialManager helper, int moduleId, String securityToken) {
        this.gadgetSpec = gadgetSpec;
        this.helper = helper;
        this.moduleId = moduleId;
        this.securityToken = securityToken;
    }

    @Override
    public int compareTo(PreparedGadget other) {
        GadgetViewRequirements gvr1 = this.getGadgetViewRequirements();
        GadgetViewRequirements gvr2 = other.getGadgetViewRequirements();
        return ("" + this.getView() + (gvr1 != null ? gvr1.getDisplayOrder() : Integer.MAX_VALUE)).compareTo("" + other.getView() + (gvr2 != null ? gvr2.getDisplayOrder() : Integer.MAX_VALUE));
    }

    public GadgetSpec getGadgetSpec() {
        return this.gadgetSpec;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public int getAppId() {
        return this.gadgetSpec.getAppId();
    }

    public String getName() {
        return this.gadgetSpec.getName();
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public String getGadgetURL() {
        return this.gadgetSpec.getGadgetURL();
    }

    GadgetViewRequirements getGadgetViewRequirements() {
        return this.gadgetSpec.getGadgetViewRequirements(this.helper.getPageName());
    }

    public String getView() {
        GadgetViewRequirements reqs = this.getGadgetViewRequirements();
        if (reqs != null) {
            return reqs.getView();
        }
        if (this.helper.getPageName().equals("individual-EDIT-MODE")) {
            return "home";
        }
        if (this.helper.getPageName().equals("individual")) {
            return "profile";
        }
        if (this.helper.getPageName().equals("gadgetDetails")) {
            return "canvas";
        }
        if (this.gadgetSpec.getGadgetURL().contains("Tool")) {
            return "small";
        }
        return null;
    }

    public String getChromeId() {
        GadgetViewRequirements reqs = this.getGadgetViewRequirements();
        if (reqs != null) {
            return reqs.getChromeId();
        }
        if (this.gadgetSpec.getGadgetURL().contains("Tool")) {
            return "gadgets-tools";
        }
        if (this.helper.getPageName().equals("individual-EDIT-MODE")) {
            return "gadgets-edit";
        }
        if (this.helper.getPageName().equals("individual")) {
            return "gadgets-view";
        }
        if (this.helper.getPageName().equals("gadgetDetails")) {
            return "gadgets-detail";
        }
        if (this.helper.getPageName().equals("search")) {
            return "gadgets-search";
        }
        return null;
    }

    public String getOptParams() {
        GadgetViewRequirements reqs = this.getGadgetViewRequirements();
        return reqs != null ? reqs.getOptParams() : "{}";
    }

    public String getCanvasURL() throws UnsupportedEncodingException {
        return "~/gadget?appId=" + this.getAppId() + "&Person=" + URLEncoder.encode(this.helper.getOwnerId(), "UTF-8");
    }

    public String toString() {
        return "" + this.moduleId + ", (" + this.gadgetSpec.toString() + ")";
    }
}

