/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dump;

import freemarker.core.Environment;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.ext.beans.SimpleMethodModel;
import freemarker.ext.beans.StringModel;
import freemarker.ext.beans.WrapperExtractor;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseDumpDirective
implements TemplateDirectiveModel {
    private static final Log log = LogFactory.getLog(BaseDumpDirective.class);
    private static final String TEMPLATE_DEFAULT = "dump.ftl";
    private static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("^(get|is)\\w");
    private ObjectWrapper defaultWrapper;

    protected Map<String, Object> getTemplateVariableDump(String varName, Environment env) throws TemplateModelException {
        this.defaultWrapper = env.getObjectWrapper();
        if (this.defaultWrapper == null) {
            this.defaultWrapper = env.getConfiguration().getObjectWrapper();
        }
        TemplateHashModel dataModel = env.getDataModel();
        TemplateModel valueToDump = dataModel.get(varName);
        return this.getTemplateVariableDump(varName, valueToDump);
    }

    protected Map<String, Object> getTemplateVariableDump(String varName, TemplateModel valueToDump) throws TemplateModelException {
        HashMap<String, Object> value = new HashMap<String, Object>();
        if (valueToDump == null) {
            value.put(Key.VALUE.toString(), Value.UNDEFINED.toString());
        } else if (valueToDump instanceof TemplateMethodModel) {
            value.putAll(this.getTemplateModelDump((TemplateMethodModel)valueToDump, varName));
        } else if (valueToDump instanceof TemplateDirectiveModel) {
            value.putAll(this.getTemplateModelDump((TemplateDirectiveModel)valueToDump, varName));
        } else {
            value.putAll(this.getDump(valueToDump));
        }
        HashMap<String, Object> dump = new HashMap<String, Object>();
        dump.put(varName, value);
        return dump;
    }

    private Map<String, Object> getDump(TemplateModel valueToDump) throws TemplateModelException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (valueToDump != null) {
            if (valueToDump instanceof TemplateSequenceModel) {
                if (valueToDump instanceof CollectionModel && !((CollectionModel)valueToDump).getSupportsIndexedAccess()) {
                    map.putAll(this.getTemplateModelDump((TemplateCollectionModel)valueToDump));
                } else {
                    map.putAll(this.getTemplateModelDump((TemplateSequenceModel)valueToDump));
                }
            } else if (valueToDump instanceof TemplateNumberModel) {
                map.putAll(this.getTemplateModelDump((TemplateNumberModel)valueToDump));
            } else if (valueToDump instanceof TemplateBooleanModel) {
                map.putAll(this.getTemplateModelDump((TemplateBooleanModel)valueToDump));
            } else if (valueToDump instanceof TemplateDateModel) {
                map.putAll(this.getTemplateModelDump((TemplateDateModel)valueToDump));
            } else if (valueToDump instanceof TemplateCollectionModel) {
                map.putAll(this.getTemplateModelDump((TemplateCollectionModel)valueToDump));
            } else if (valueToDump instanceof StringModel) {
                Object unwrappedModel = DeepUnwrap.permissiveUnwrap((TemplateModel)valueToDump);
                if (unwrappedModel instanceof String) {
                    map.putAll(this.getTemplateModelDump((TemplateScalarModel)valueToDump));
                } else {
                    map.putAll(this.getTemplateModelDump((TemplateHashModelEx)valueToDump));
                }
            } else if (valueToDump instanceof TemplateScalarModel) {
                map.putAll(this.getTemplateModelDump((TemplateScalarModel)valueToDump));
            } else if (valueToDump instanceof TemplateHashModelEx) {
                map.putAll(this.getTemplateModelDump((TemplateHashModelEx)valueToDump));
            } else if (valueToDump instanceof TemplateHashModel) {
                map.putAll(this.getTemplateModelDump((TemplateHashModel)valueToDump));
            } else {
                map.putAll(this.getTemplateModelDump(valueToDump));
            }
        } else {
            map.put(Key.VALUE.toString(), Value.NULL.toString());
        }
        return map;
    }

    private Map<String, Object> getTemplateModelDump(TemplateScalarModel model) throws TemplateModelException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Key.TYPE.toString(), (Object)Type.STRING);
        map.put(Key.VALUE.toString(), model.getAsString());
        return map;
    }

    private Map<String, Object> getTemplateModelDump(TemplateBooleanModel model) throws TemplateModelException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Key.TYPE.toString(), (Object)Type.BOOLEAN);
        map.put(Key.VALUE.toString(), model.getAsBoolean());
        return map;
    }

    private Map<String, Object> getTemplateModelDump(TemplateNumberModel model) throws TemplateModelException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Key.TYPE.toString(), (Object)Type.NUMBER);
        map.put(Key.VALUE.toString(), model.getAsNumber());
        return map;
    }

    private Map<String, Object> getTemplateModelDump(TemplateDateModel model) throws TemplateModelException {
        DateType type;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Key.TYPE.toString(), (Object)Type.DATE);
        int dateType = model.getDateType();
        switch (dateType) {
            case 2: {
                type = DateType.DATE;
                break;
            }
            case 3: {
                type = DateType.DATETIME;
                break;
            }
            case 1: {
                type = DateType.TIME;
                break;
            }
            default: {
                type = DateType.UNKNOWN;
            }
        }
        map.put(Key.DATE_TYPE.toString(), (Object)type);
        map.put(Key.VALUE.toString(), model.getAsDate());
        return map;
    }

    private Map<String, Object> getTemplateModelDump(TemplateHashModel model) throws TemplateModelException {
        log.debug((Object)("Dumping model " + model));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Key.TYPE.toString(), (Object)Type.HASH);
        return map;
    }

    private Map<String, Object> getTemplateModelDump(TemplateSequenceModel model) throws TemplateModelException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Key.TYPE.toString(), (Object)Type.SEQUENCE);
        int itemCount = model.size();
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            TemplateModel item = model.get(i);
            items.add(this.getDump(item));
        }
        map.put(Key.VALUE.toString(), items);
        return map;
    }

    private Map<String, Object> getTemplateModelDump(TemplateHashModelEx model) throws TemplateModelException {
        Object unwrappedModel = DeepUnwrap.permissiveUnwrap((TemplateModel)model);
        if (unwrappedModel instanceof Map) {
            return this.getMapDump(model);
        }
        return this.getObjectDump(model, unwrappedModel);
    }

    private Map<String, Object> getMapDump(TemplateHashModelEx model) throws TemplateModelException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Key.TYPE.toString(), (Object)Type.HASH_EX);
        TreeMap<String, Map<String, Object>> items = new TreeMap<String, Map<String, Object>>();
        TemplateCollectionModel keys = model.keys();
        TemplateModelIterator iModel = keys.iterator();
        while (iModel.hasNext()) {
            TemplateModel value;
            String key = iModel.next().toString();
            if ("class".equals(key) || "empty".equals(key) || (value = model.get(key)) instanceof TemplateMethodModel) continue;
            items.put(key, this.getDump(value));
        }
        map.put(Key.VALUE.toString(), items);
        return map;
    }

    private Map<String, Object> getObjectDump(TemplateHashModelEx model, Object object) throws TemplateModelException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Key.TYPE.toString(), object.getClass().getName());
        if (object instanceof Method) {
            return map;
        }
        TreeMap<String, Map<String, Object>> properties = new TreeMap<String, Map<String, Object>>();
        TreeMap<String, Map<String, Object>> methods = new TreeMap<String, Map<String, Object>>();
        TemplateCollectionModel keys = model.keys();
        TemplateModelIterator iModel = keys.iterator();
        HashSet<String> keySet = new HashSet<String>();
        while (iModel.hasNext()) {
            String key = iModel.next().toString();
            keySet.add(key);
        }
        if (keySet.size() > 0) {
            Method[] classMethods;
            Class<?> cls = object.getClass();
            for (Method method : classMethods = cls.getMethods()) {
                String propertyName;
                Class<?> c;
                if ("declaringClass".equals(method.getName()) || (c = method.getDeclaringClass()) == null || c.equals(Object.class) || c.equals(Constructor.class) || c.equals(Field.class) || c.getPackage().getName().startsWith("sun.") || c.getPackage().getName().startsWith("java.lang") || c.getPackage().getName().startsWith("java.security") || method.isAnnotationPresent(Deprecated.class)) continue;
                String methodName = method.getName();
                Matcher matcher = PROPERTY_NAME_PATTERN.matcher(methodName);
                if (matcher.find() && keySet.contains(propertyName = this.getPropertyName(methodName))) {
                    try {
                        TemplateModel value = model.get(propertyName);
                        properties.put(propertyName, this.getDump(value));
                    }
                    catch (Throwable th) {
                        log.error((Object)("problem dumping " + propertyName + " on " + object.getClass().getName() + " declared in " + c.getName()), th);
                    }
                    continue;
                }
                if (!keySet.contains(methodName)) continue;
                String methodDisplayName = this.getMethodDisplayName(method);
                if (methodDisplayName.endsWith("()")) {
                    SimpleMethodModel methodModel = (SimpleMethodModel)model.get(methodName);
                    try {
                        Object result = methodModel.exec(null);
                        ObjectWrapper wrapper = this.getWrapper(model);
                        TemplateModel wrappedResult = wrapper.wrap(result);
                        methods.put(methodDisplayName, this.getDump(wrappedResult));
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    continue;
                }
                String returnTypeName = this.getReturnTypeName(method);
                HashMap<String, String> methodValue = new HashMap<String, String>();
                if (!returnTypeName.equals("void")) {
                    methodValue.put(Key.TYPE.toString(), returnTypeName);
                }
                methods.put(methodDisplayName, methodValue);
            }
        }
        HashMap<String, TreeMap<String, Map<String, Object>>> objectValue = new HashMap<String, TreeMap<String, Map<String, Object>>>(2);
        objectValue.put(Key.PROPERTIES.toString(), properties);
        objectValue.put(Key.METHODS.toString(), methods);
        map.put(Key.VALUE.toString(), objectValue);
        return map;
    }

    private ObjectWrapper getWrapper(TemplateHashModelEx model) {
        if (model instanceof BeanModel) {
            return WrapperExtractor.getWrapper((BeanModel)model);
        }
        if (this.defaultWrapper != null) {
            return this.defaultWrapper;
        }
        return new BeansWrapper();
    }

    private String getMethodDisplayName(Method method) {
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        ArrayList<String> paramTypeList = new ArrayList<String>(paramTypes.length);
        if (paramTypes.length > 0) {
            for (Class<?> cls : paramTypes) {
                paramTypeList.add(this.getSimpleTypeName(cls));
            }
        }
        methodName = methodName + "(" + StringUtils.join(paramTypeList, (String)", ") + ")";
        return methodName;
    }

    private String getReturnTypeName(Method method) {
        String packageName;
        Class<?> cls = method.getReturnType();
        Package pkg = cls.getPackage();
        if (pkg != null && (packageName = pkg.getName()).startsWith("java")) {
            return this.getSimpleTypeName(cls);
        }
        return cls.getName();
    }

    private String getSimpleTypeName(Class<?> cls) {
        return cls.getSimpleName().replace("[]", "s");
    }

    private String getPropertyName(String methodName) {
        String keyName = methodName.replaceAll("^(get|is)", "");
        return StringUtils.uncapitalize((String)keyName);
    }

    private Map<String, Object> getTemplateModelDump(TemplateCollectionModel model) throws TemplateModelException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Key.TYPE.toString(), (Object)Type.COLLECTION);
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        for (TemplateModel m : model) {
            items.add(this.getDump(m));
        }
        map.put(Key.VALUE.toString(), items);
        return map;
    }

    private Map<String, Object> getTemplateModelDump(TemplateMethodModel model, String varName) throws TemplateModelException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Key.TYPE.toString(), (Object)Type.METHOD);
        map.put(Key.CLASS.toString(), model.getClass().getName());
        map.put(Key.HELP.toString(), this.getHelp((TemplateModel)model, varName));
        return map;
    }

    private Map<String, Object> getTemplateModelDump(TemplateDirectiveModel model, String varName) throws TemplateModelException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Key.TYPE.toString(), (Object)Type.DIRECTIVE);
        map.put(Key.CLASS.toString(), model.getClass().getName());
        map.put(Key.HELP.toString(), this.getHelp((TemplateModel)model, varName));
        return map;
    }

    private Map<String, Object> getHelp(TemplateModel model, String varName) {
        if (model instanceof TemplateMethodModel || model instanceof TemplateDirectiveModel) {
            String modelClass = model instanceof TemplateMethodModel ? "TemplateMethodModel" : "TemplateDirectiveModel";
            Class<?> cls = model.getClass();
            try {
                Method help = cls.getMethod("help", String.class);
                try {
                    return (Map)help.invoke((Object)model, varName);
                }
                catch (ClassCastException e) {
                    log.error((Object)("Method help() of " + modelClass + " of class " + cls.getName() + " has incorrect return type."));
                    return null;
                }
                catch (Exception e) {
                    log.error((Object)("Error invoking method help() on " + modelClass + " of class " + cls.getName()));
                    return null;
                }
            }
            catch (NoSuchMethodException e) {
                log.info((Object)("No help() method defined for " + modelClass + " of class " + cls.getName()));
                return null;
            }
            catch (Exception e) {
                log.error((Object)("Error getting method help() for " + modelClass + " " + cls.getName()));
                return null;
            }
        }
        return null;
    }

    private Map<String, Object> getTemplateModelDump(TemplateModel model) throws TemplateModelException {
        log.debug((Object)("Found template model of type " + model.getClass().getName()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object unwrappedModel = DeepUnwrap.permissiveUnwrap((TemplateModel)model);
        map.put(Key.TYPE.toString(), unwrappedModel.getClass().getName());
        map.put(Key.VALUE.toString(), unwrappedModel.toString());
        return map;
    }

    protected void dump(Map<String, Object> dump, Environment env, String title) throws TemplateException, IOException {
        this.dump(dump, env, title, TEMPLATE_DEFAULT);
    }

    protected void dump(Map<String, Object> dump, Environment env, String title, String templateName) throws TemplateException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dumpValue", dump);
        map.put("title", title);
        this.writeDump(map, env, templateName);
    }

    protected void writeDump(Map<String, Object> map, Environment env, String templateName) throws TemplateException, IOException {
        map.putAll(this.toMap(env.getDataModel()));
        Template template = env.getConfiguration().getTemplate(templateName);
        StringWriter sw = new StringWriter();
        template.process(map, (Writer)sw);
        Writer out = env.getOut();
        out.write(sw.toString());
    }

    public Map<String, Object> help(String name) {
        return new HashMap<String, Object>();
    }

    protected Map<? extends String, ? extends Object> toMap(Object hash) throws TemplateModelException {
        HashMap<String, TemplateModel> outMap = new HashMap<String, TemplateModel>();
        if (hash instanceof TemplateHashModelEx) {
            TemplateHashModelEx thme = (TemplateHashModelEx)hash;
            for (String key : this.junkToStrings(thme.keys())) {
                outMap.put(key, thme.get(key));
            }
        } else {
            log.error((Object)("Freemarker is passing odd objects to method toMap(): " + hash.getClass().getName()));
        }
        return outMap;
    }

    protected List<String> junkToStrings(TemplateCollectionModel junk) {
        ArrayList<String> keys = new ArrayList<String>();
        try {
            for (TemplateModel obj : junk) {
                if (obj instanceof StringModel) {
                    keys.add(((StringModel)obj).getAsString());
                    continue;
                }
                if (obj instanceof SimpleScalar) {
                    keys.add(((SimpleScalar)obj).getAsString());
                    continue;
                }
                log.error((Object)("Freemarker is setting keys to hashes as non-strings: " + obj.getClass().getName()));
            }
        }
        catch (Exception ex) {
            log.error((Object)"Freemarker is messing with us", (Throwable)ex);
        }
        return keys;
    }

    static enum DateType {
        DATE("Date"),
        DATETIME("DateTime"),
        TIME("Time"),
        UNKNOWN("Unknown");

        private final String type;

        private DateType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    static enum Type {
        BOOLEAN("Boolean"),
        COLLECTION("Collection"),
        DATE("Date"),
        DIRECTIVE("Directive"),
        HASH("Hash"),
        HASH_EX("Hash"),
        METHOD("Method"),
        NUMBER("Number"),
        SEQUENCE("Sequence"),
        STRING("String");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    static enum Value {
        NULL("[null]"),
        UNDEFINED("[undefined]");

        private final String value;

        private Value(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    static enum Key {
        CLASS("class"),
        DATE_TYPE("dateType"),
        HELP("help"),
        METHODS("methods"),
        PROPERTIES("properties"),
        TYPE("type"),
        VALUE("value");

        private final String key;

        private Key(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

