/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dump;

import freemarker.core.Environment;
import freemarker.ext.dump.BaseDumpDirective;
import freemarker.ext.dump.DumpDirective;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DumpAllDirective
extends BaseDumpDirective {
    private static final Log log = LogFactory.getLog(DumpDirective.class);

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (params.size() != 0) {
            throw new TemplateModelException("The dumpAll directive doesn't allow parameters.");
        }
        if (loopVars.length != 0) {
            throw new TemplateModelException("The dump directive doesn't allow loop variables.");
        }
        if (body != null) {
            throw new TemplateModelException("The dump directive doesn't allow nested content.");
        }
        SortedMap<String, Object> dump = this.getDataModelDump(env);
        String title = "Template data model dump for " + env.getTemplate().getName();
        this.dump(dump, env, title);
    }

    SortedMap<String, Object> getDataModelDump(Environment env) throws TemplateModelException {
        TreeMap<String, Object> dump = new TreeMap<String, Object>();
        TemplateHashModel dataModel = env.getDataModel();
        Map unwrappedDataModel = (Map)DeepUnwrap.permissiveUnwrap((TemplateModel)dataModel);
        ArrayList varNames = new ArrayList(unwrappedDataModel.keySet());
        for (String varName : varNames) {
            dump.putAll(this.getTemplateVariableDump(varName, dataModel.get(varName)));
        }
        return dump;
    }

    @Override
    public Map<String, Object> help(String name) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("effect", "Dumps the contents of the template data model.");
        ArrayList<String> examples = new ArrayList<String>();
        examples.add("<@" + name + " />");
        map.put("examples", examples);
        return map;
    }
}

