/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.fragments.tpf;

import org.linkeddatafragments.fragments.tpf.ITriplePatternElement;

public class TriplePatternElementFactory<CTT, NVT, AVT> {
    public ITriplePatternElement<CTT, NVT, AVT> createUnspecifiedVariable() {
        return new UnspecifiedVariable();
    }

    public ITriplePatternElement<CTT, NVT, AVT> createNamedVariable(NVT v) {
        return new NamedVariable(v);
    }

    public ITriplePatternElement<CTT, NVT, AVT> createAnonymousVariable(AVT bnode) {
        return new AnonymousVariable(bnode);
    }

    public ITriplePatternElement<CTT, NVT, AVT> createConstantRDFTerm(CTT term) {
        return new ConstantRDFTerm(term);
    }

    public static class ConstantRDFTerm<CTT, NVT, AVT>
    implements ITriplePatternElement<CTT, NVT, AVT> {
        protected final CTT t;

        public ConstantRDFTerm(CTT term) {
            this.t = term;
        }

        @Override
        public boolean isVariable() {
            return false;
        }

        @Override
        public boolean isSpecificVariable() {
            return false;
        }

        @Override
        public boolean isNamedVariable() {
            return false;
        }

        @Override
        public NVT asNamedVariable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAnonymousVariable() {
            return false;
        }

        @Override
        public AVT asAnonymousVariable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CTT asConstantTerm() {
            return this.t;
        }

        public String toString() {
            return "ConstantRDFTerm(" + this.t.toString() + ")(type: " + this.t.getClass().getSimpleName() + ")";
        }
    }

    public static class AnonymousVariable<CTT, NVT, AVT>
    extends SpecificVariable<CTT, NVT, AVT> {
        protected final AVT bn;

        public AnonymousVariable(AVT bnode) {
            this.bn = bnode;
        }

        @Override
        public boolean isNamedVariable() {
            return false;
        }

        @Override
        public NVT asNamedVariable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAnonymousVariable() {
            return true;
        }

        @Override
        public AVT asAnonymousVariable() {
            return this.bn;
        }

        public String toString() {
            return "AnonymousVariable(" + this.bn.toString() + ")";
        }
    }

    public static class NamedVariable<CTT, NVT, AVT>
    extends SpecificVariable<CTT, NVT, AVT> {
        protected final NVT v;

        public NamedVariable(NVT variable) {
            this.v = variable;
        }

        @Override
        public boolean isNamedVariable() {
            return true;
        }

        @Override
        public NVT asNamedVariable() {
            return this.v;
        }

        @Override
        public boolean isAnonymousVariable() {
            return false;
        }

        @Override
        public AVT asAnonymousVariable() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "NamedVariable(" + this.v.toString() + ")";
        }
    }

    public static abstract class SpecificVariable<CTT, NVT, AVT>
    extends Variable<CTT, NVT, AVT> {
        @Override
        public boolean isSpecificVariable() {
            return true;
        }
    }

    public static class UnspecifiedVariable<CTT, NVT, AVT>
    extends Variable<CTT, NVT, AVT> {
        @Override
        public boolean isSpecificVariable() {
            return false;
        }

        @Override
        public boolean isNamedVariable() {
            return false;
        }

        @Override
        public NVT asNamedVariable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAnonymousVariable() {
            return false;
        }

        @Override
        public AVT asAnonymousVariable() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "UnspecifiedVariable";
        }
    }

    public static abstract class Variable<CTT, NVT, AVT>
    implements ITriplePatternElement<CTT, NVT, AVT> {
        @Override
        public boolean isVariable() {
            return true;
        }

        @Override
        public CTT asConstantTerm() {
            throw new UnsupportedOperationException();
        }
    }
}

