/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.testing;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RecordingProxy {
    public static <T> T create(T inner, Class<T> interfaze) {
        RecordingInvocationHandler handler = new RecordingInvocationHandler(inner);
        ClassLoader classLoader = interfaze.getClassLoader();
        Class[] interfaces = new Class[]{interfaze, MethodCallRecorder.class};
        return interfaze.cast(Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler));
    }

    public static class RecordingInvocationHandler
    implements InvocationHandler {
        private final Object inner;
        private final List<MethodCall> methodCalls = new ArrayList<MethodCall>();

        RecordingInvocationHandler(Object inner) {
            this.inner = inner;
        }

        List<MethodCall> getMethodCalls() {
            return new ArrayList<MethodCall>(this.methodCalls);
        }

        void reset() {
            this.methodCalls.clear();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "getMethodCalls": {
                    return new ArrayList<MethodCall>(this.methodCalls);
                }
                case "getMethodCallNames": {
                    return MethodCall.justNames(this.methodCalls);
                }
                case "resetMethodCalls": {
                    this.methodCalls.clear();
                    return null;
                }
                case "equals": {
                    if (args == null) {
                        return false;
                    }
                    if (args.length == 0) {
                        return false;
                    }
                    return args[0].equals(this.inner);
                }
            }
            this.methodCalls.add(new MethodCall(method.getName(), args));
            return method.invoke(this.inner, args);
        }
    }

    public static class MethodCall {
        private final String name;
        private final List<Object> argList;

        public static Object justNames(List<MethodCall> methodCalls) {
            ArrayList<String> names = new ArrayList<String>();
            for (MethodCall methodCall : methodCalls) {
                names.add(methodCall.getName());
            }
            return names;
        }

        public MethodCall(String name, Object[] args) {
            this.name = name;
            this.argList = args == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(args)));
        }

        public String getName() {
            return this.name;
        }

        public List<Object> getArgList() {
            return this.argList;
        }
    }

    public static interface MethodCallRecorder {
        public List<MethodCall> getMethodCalls();

        public List<String> getMethodCallNames();

        public void resetMethodCalls();
    }
}

