/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Test;

public class JenaBaseDaoTest {
    String isDependentRelation = " <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#stubObjectPropertyAnnot> \"true\"^^xsd:boolean .\n";
    String nosePropIsDependentRel = "<http://vitro.mannlib.cornell.edu/ns/vitro/0.7#stubObjectPropertyAnnot> rdf:type owl:AnnotationProperty .\n ex:hasNose " + this.isDependentRelation;
    String prefixesN3 = "@prefix vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> . \n@prefix xsd: <" + XSD.getURI() + "> . \n " + "@prefix rdf:  <" + RDF.getURI() + "> . \n" + "@prefix rdfs: <" + RDFS.getURI() + "> . \n" + "@prefix owl:  <" + OWL.getURI() + "> . \n" + "@prefix ex: <http://example.com/> . \n";

    @Test
    public void smartRemoveTestForIndivdiualDelete() {
        String n3 = this.prefixesN3 + "ex:prop1 rdf:type owl:ObjectProperty ." + "ex:prop1 rdfs:label \"Prop 1 Dependent Relation\" ." + "ex:prop1 " + this.isDependentRelation;
        Model readInModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.add(readInModel);
        WebappDaoFactoryJena wdfj = new WebappDaoFactoryJena(ontModel);
        try {
            ObjectProperty prop1 = wdfj.getObjectPropertyDao().getObjectPropertyByURI("http://example.com/prop1");
            Assert.assertNotNull((Object)prop1);
            IndividualImpl ind = new IndividualImpl();
            ind.setURI("http://example.com/bob");
            ind.setName("Smith, Bob");
            wdfj.getIndividualDao().insertNewIndividual((Individual)ind);
            IndividualImpl indxyz = new IndividualImpl();
            indxyz.setURI("http://example.com/depResXYZ");
            indxyz.setName("depResXYZ");
            wdfj.getIndividualDao().insertNewIndividual((Individual)indxyz);
            IndividualImpl indAbc = new IndividualImpl();
            indAbc.setURI("http://example.com/depResNested");
            indAbc.setName("depResNested");
            wdfj.getIndividualDao().insertNewIndividual((Individual)indAbc);
            ObjectPropertyStatementImpl ops = new ObjectPropertyStatementImpl();
            ops.setSubjectURI("http://example.com/bob");
            ops.setPropertyURI("http://example.com/prop1");
            ops.setObjectURI("http://example.com/depResXYZ");
            wdfj.getObjectPropertyStatementDao().insertNewObjectPropertyStatement((ObjectPropertyStatement)ops);
            ops = new ObjectPropertyStatementImpl();
            ops.setSubjectURI("http://example.com/depResXYZ");
            ops.setPropertyURI("http://example.com/prop1");
            ops.setObjectURI("http://example.com/depResNested");
            wdfj.getObjectPropertyStatementDao().insertNewObjectPropertyStatement((ObjectPropertyStatement)ops);
            wdfj.getIndividualDao().deleteIndividual("http://example.com/depResXYZ");
            String expected = "@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> . @prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .@prefix owl:     <http://www.w3.org/2002/07/owl#> . <http://example.com/bob>      a       owl:Thing ;     rdfs:label \"Smith, Bob\"@en-US . <http://example.com/prop1>      a       owl:ObjectProperty ;     rdfs:label \"Prop 1 Dependent Relation\" ; " + this.isDependentRelation;
            Model expectedModel = ModelFactory.createOntologyModel().read((Reader)new StringReader(expected), "", "N3");
            this.assertEquivalentModels(expectedModel, (Model)ontModel);
        }
        catch (InsertException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void smartRemoveTestForObjPropStmtDelete() {
        String n3 = this.prefixesN3 + "ex:prop1 rdf:type owl:ObjectProperty ." + "ex:prop1 rdfs:label \"Prop 1 Dependent Relation\" ." + "ex:prop1 " + this.isDependentRelation;
        Model readInModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        OntModel model = ModelFactory.createOntologyModel();
        model.add(readInModel);
        WebappDaoFactoryJena wdfj = new WebappDaoFactoryJena(model);
        IndividualImpl ind = new IndividualImpl();
        ind.setURI("http://example.com/bob");
        ind.setName("Smith, Bob");
        try {
            wdfj.getIndividualDao().insertNewIndividual((Individual)ind);
        }
        catch (InsertException e) {
            Assert.fail((String)"Could not create new Individual Smith, Bob");
        }
        IndividualImpl indxyz = new IndividualImpl();
        indxyz.setURI("http://example.com/depResXYZ");
        indxyz.setName("depResXYZ");
        try {
            wdfj.getIndividualDao().insertNewIndividual((Individual)indxyz);
        }
        catch (InsertException e) {
            Assert.fail((String)"Could not create new Individual depResXYZ");
        }
        IndividualImpl indAbc = new IndividualImpl();
        indAbc.setURI("http://example.com/depResNested");
        indAbc.setName("depResNested");
        try {
            wdfj.getIndividualDao().insertNewIndividual((Individual)indAbc);
        }
        catch (InsertException e) {
            Assert.fail((String)"Could not create new Individual depResNested");
        }
        ObjectPropertyStatementImpl ops = new ObjectPropertyStatementImpl();
        ops.setSubjectURI("http://example.com/bob");
        ops.setPropertyURI("http://example.com/prop1");
        ops.setObjectURI("http://example.com/depResXYZ");
        wdfj.getObjectPropertyStatementDao().insertNewObjectPropertyStatement((ObjectPropertyStatement)ops);
        ops = new ObjectPropertyStatementImpl();
        ops.setSubjectURI("http://example.com/depResXYZ");
        ops.setPropertyURI("http://example.com/prop1");
        ops.setObjectURI("http://example.com/depResNested");
        wdfj.getObjectPropertyStatementDao().insertNewObjectPropertyStatement((ObjectPropertyStatement)ops);
        ops = new ObjectPropertyStatementImpl();
        ops.setSubjectURI("http://example.com/bob");
        ops.setPropertyURI("http://example.com/prop1");
        ops.setObjectURI("http://example.com/depResXYZ");
        wdfj.getObjectPropertyStatementDao().deleteObjectPropertyStatement((ObjectPropertyStatement)ops);
        String expected = "@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> . @prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .@prefix owl:     <http://www.w3.org/2002/07/owl#> . <http://example.com/bob>      a       owl:Thing ;     rdfs:label \"Smith, Bob\"@en-US . <http://example.com/prop1>      a       owl:ObjectProperty ;     rdfs:label \"Prop 1 Dependent Relation\" ; " + this.isDependentRelation;
        Model expectedModel = ModelFactory.createOntologyModel().read((Reader)new StringReader(expected), "", "N3");
        this.assertEquivalentModels(expectedModel, (Model)model);
    }

    @Test
    public void smartRemoveTestForObjPropDelete() {
        String n3 = this.prefixesN3 + "ex:prop1 rdf:type owl:ObjectProperty ." + "ex:prop1 rdfs:label \"Prop 1 Dependent Relation\" ." + "ex:prop1 " + this.isDependentRelation;
        Model readInModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.add(readInModel);
        WebappDaoFactoryJena wdfj = new WebappDaoFactoryJena(ontModel);
        try {
            ObjectProperty prop1 = wdfj.getObjectPropertyDao().getObjectPropertyByURI("http://example.com/prop1");
            Assert.assertNotNull((Object)prop1);
            IndividualImpl ind = new IndividualImpl();
            ind.setURI("http://example.com/bob");
            ind.setName("Smith, Bob");
            wdfj.getIndividualDao().insertNewIndividual((Individual)ind);
            IndividualImpl indxyz = new IndividualImpl();
            indxyz.setURI("http://example.com/depResXYZ");
            indxyz.setName("depResXYZ");
            wdfj.getIndividualDao().insertNewIndividual((Individual)indxyz);
            IndividualImpl indAbc = new IndividualImpl();
            indAbc.setURI("http://example.com/depResNested");
            indAbc.setName("depResNested");
            wdfj.getIndividualDao().insertNewIndividual((Individual)indAbc);
            ObjectPropertyStatementImpl ops = new ObjectPropertyStatementImpl();
            ops.setSubjectURI("http://example.com/bob");
            ops.setPropertyURI("http://example.com/prop1");
            ops.setObjectURI("http://example.com/depResXYZ");
            wdfj.getObjectPropertyStatementDao().insertNewObjectPropertyStatement((ObjectPropertyStatement)ops);
            ops = new ObjectPropertyStatementImpl();
            ops.setSubjectURI("http://example.com/depResXYZ");
            ops.setPropertyURI("http://example.com/prop1");
            ops.setObjectURI("http://example.com/depResNested");
            wdfj.getObjectPropertyStatementDao().insertNewObjectPropertyStatement((ObjectPropertyStatement)ops);
            wdfj.getObjectPropertyDao().deleteObjectProperty(prop1);
            String expected = "@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> . @prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> .@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .@prefix owl:     <http://www.w3.org/2002/07/owl#> . <http://example.com/bob>      a       owl:Thing ;     rdfs:label \"Smith, Bob\"@en-US . ";
            Model expectedModel = ModelFactory.createOntologyModel().read((Reader)new StringReader(expected), "", "N3");
            this.assertEquivalentModels(expectedModel, (Model)ontModel);
        }
        catch (InsertException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testABoxAssertionsRemovedWhenPropertyRemoved() throws InsertException {
        OntModel preModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel postModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        WebappDaoFactoryJena preWadf = new WebappDaoFactoryJena(preModel);
        ObjectProperty objPropNotForDeletion = new ObjectProperty();
        objPropNotForDeletion.setURI("http://dont.delete.me/objProp");
        preWadf.getObjectPropertyDao().insertObjectProperty(objPropNotForDeletion);
        DataProperty dataPropNotForDeletion = new DataProperty();
        dataPropNotForDeletion.setURI("http://dont.delete.me/dataProp");
        preWadf.getDataPropertyDao().insertDataProperty(dataPropNotForDeletion);
        ObjectPropertyStatementImpl objPropStmtNotForDeletion = new ObjectPropertyStatementImpl();
        objPropStmtNotForDeletion.setSubjectURI("http://individual.example.org/a/");
        objPropStmtNotForDeletion.setProperty(objPropNotForDeletion);
        objPropStmtNotForDeletion.setObjectURI("http://individual.example.org/b/");
        preWadf.getObjectPropertyStatementDao().insertNewObjectPropertyStatement((ObjectPropertyStatement)objPropStmtNotForDeletion);
        DataPropertyStatementImpl dataPropStmtNotForDeletion = new DataPropertyStatementImpl();
        dataPropStmtNotForDeletion.setIndividualURI("http://individual.example.org/a/");
        dataPropStmtNotForDeletion.setDatapropURI(dataPropNotForDeletion.getURI());
        dataPropStmtNotForDeletion.setData("junk");
        postModel.add((Model)preModel);
        ObjectProperty objProp = new ObjectProperty();
        objProp.setURI("http://example.org/objProp");
        preWadf.getObjectPropertyDao().insertObjectProperty(objProp);
        DataProperty dataProp = new DataProperty();
        dataProp.setURI("http://example.org/dataProp");
        preWadf.getDataPropertyDao().insertDataProperty(dataProp);
        ObjectPropertyStatementImpl objPropStmtForDeletion = new ObjectPropertyStatementImpl();
        objPropStmtForDeletion.setSubjectURI("http://example.org/sdfadsf/");
        objPropStmtForDeletion.setProperty(objProp);
        objPropStmtForDeletion.setObjectURI("http://example.org/asdfasdfasfa/");
        preWadf.getObjectPropertyStatementDao().insertNewObjectPropertyStatement((ObjectPropertyStatement)objPropStmtForDeletion);
        DataPropertyStatementImpl dataPropStmtForDeletion = new DataPropertyStatementImpl();
        dataPropStmtForDeletion.setIndividualURI("http://example.org/asdf123/");
        dataPropStmtForDeletion.setDatapropURI(dataProp.getURI());
        dataPropStmtForDeletion.setData("I will be deleted!");
        preWadf.getDataPropertyStatementDao().insertNewDataPropertyStatement((DataPropertyStatement)dataPropStmtForDeletion);
        preWadf.getObjectPropertyDao().deleteObjectProperty(objProp);
        preWadf.getDataPropertyDao().deleteDataProperty(dataProp);
        Assert.assertTrue((preModel.size() == postModel.size() ? 1 : 0) != 0);
    }

    @Test
    public void testPreventInvalidRestrictionsOnDeletion() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        WebappDaoFactoryJena wadf = new WebappDaoFactoryJena(m);
        String ns = "http://example.org/ontology/";
        String class1URI = ns + "Class1";
        String class2URI = ns + "Class2";
        String propURI = ns + "property";
        OntClass class1 = m.createClass(class1URI);
        OntClass class2 = m.createClass(class2URI);
        com.hp.hpl.jena.ontology.ObjectProperty prop = m.createObjectProperty(propURI);
        AllValuesFromRestriction rest = m.createAllValuesFromRestriction(null, (Property)prop, (Resource)class2);
        class1.addSuperClass((Resource)rest);
        ObjectProperty op = wadf.getObjectPropertyDao().getObjectPropertyByURI(propURI);
        wadf.getObjectPropertyDao().deleteObjectProperty(op);
        Assert.assertEquals((long)class1.listSuperClasses().toSet().size(), (long)0L);
        Assert.assertEquals((long)m.size(), (long)2L);
        prop = m.createObjectProperty(propURI);
        rest = m.createAllValuesFromRestriction(null, (Property)prop, (Resource)class2);
        class1.addSuperClass((Resource)rest);
        VClass vclass = wadf.getVClassDao().getVClassByURI(class2URI);
        wadf.getVClassDao().deleteVClass(vclass);
        Assert.assertEquals((long)class1.listSuperClasses().toSet().size(), (long)0L);
        Assert.assertEquals((long)m.size(), (long)2L);
    }

    private void assertEquivalentModels(Model expected, Model actual) {
        this.wipeOutModTime(expected);
        this.wipeOutModTime(actual);
        if (actual.isIsomorphicWith(expected)) {
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(out, true);
        p.println("Models do not match: expected <");
        expected.write((OutputStream)out);
        p.println("> but was <");
        actual.write((OutputStream)out);
        p.println(">");
        Assert.fail((String)out.toString());
    }

    private void wipeOutModTime(Model model) {
        model.removeAll(null, model.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#modTime"), null);
    }
}

