/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.search.controller.UpdateUrisInIndex;
import java.io.Reader;
import java.io.StringReader;
import java.util.Scanner;
import org.junit.Assert;
import org.junit.Test;

public class UpdateUrisInIndexTest {
    @Test(expected=NullPointerException.class)
    public void nullString() {
        this.scan(null, 0);
    }

    @Test
    public void emptyString() {
        this.scan("", 0);
    }

    @Test
    public void nothingButDelimiters() {
        this.scan(" , ", 0);
        this.scan("\n", 0);
        this.scan("\n\n\n", 0);
        this.scan("\n, \t\r   ,\n\n", 0);
    }

    @Test
    public void oneTokenNoDelimiters() {
        this.scan("http://bogus.com/n234", 1);
    }

    @Test
    public void oneTokenAssortedDelimiters() {
        this.scan("http://bogus.com/n234\n", 1);
        this.scan("\nhttp://bogus.com/n234", 1);
        this.scan("\nhttp://bogus.com/n234\n", 1);
    }

    @Test
    public void twoTokensAssortedDelimiters() {
        this.scan("http://bogus.com/n234\nhttp://bogus.com/n442", 2);
        this.scan("http://bogus.com/n234, http://bogus.com/n442", 2);
        this.scan("http://bogus.com/n234,\nhttp://bogus.com/n442\n", 2);
    }

    @Test
    public void nonBreakingSpace() {
        this.scan("non\u00a0breaking\u00a0space", 1);
    }

    @Test
    public void omnibus() {
        this.scan("  a  ,  b,c d\t,\re", 5);
    }

    public void scan(String input, int expectedUris) {
        StringReader reader = input == null ? null : new StringReader(input);
        Scanner it = new UpdateUrisInIndex().createScanner((Reader)reader);
        int count = 0;
        while (it.hasNext()) {
            String uri = (String)it.next();
            if (uri == null) {
                Assert.fail((String)("Scanner should not return null strings \n Null string for uri #" + count + " for input '" + input + "'"));
            } else if (uri.isEmpty()) {
                Assert.fail((String)("Scanner should not return empty strings \n Empty string for uri #" + count + " for input '" + input + "'"));
            }
            ++count;
        }
        Assert.assertEquals((String)("Incorrect number of URIs from input '" + input + "'"), (long)expectedUris, (long)count);
    }
}

