/*
 * Decompiled with CFR 0.152.
 */
package stubs.com.hp.hpl.jena.rdf.model.ModelMaker;

import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelReader;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.CannotCreateException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.HashMap;
import java.util.Map;

public abstract class ModelMakerStub
implements ModelMaker {
    protected final Model defaultModel;
    protected final Model freshModel;
    protected final Map<String, Model> models = new HashMap<String, Model>();
    protected final GraphMaker graphMaker = new SimpleGraphMaker();

    public static ModelMakerStub rigorous(Model defaultModel, Model freshModel) {
        return new ModelMakerRigorousStub(defaultModel, freshModel);
    }

    public static ModelMakerStub relaxed(Model defaultModel, Model freshModel) {
        return new ModelMakerRelaxedStub(defaultModel, freshModel);
    }

    protected ModelMakerStub(Model defaultModel, Model freshModel) {
        this.defaultModel = defaultModel;
        this.freshModel = freshModel;
    }

    public ModelMakerStub put(String uri, Model model) {
        this.models.put(uri, model);
        return this;
    }

    public GraphMaker getGraphMaker() {
        return this.graphMaker;
    }

    public void close() {
    }

    public boolean hasModel(String name) {
        return this.models.containsKey(name);
    }

    public ExtendedIterator<String> listModels() {
        return WrappedIterator.create(this.models.keySet().iterator());
    }

    public Model createModel(String name) {
        return this.createModel(name, false);
    }

    public Model createModel(String name, boolean strict) {
        if (this.hasModel(name)) {
            if (strict) {
                throw new AlreadyExistsException(name);
            }
            return this.models.get(name);
        }
        return this.freshModel;
    }

    public Model createDefaultModel() {
        return this.defaultModel;
    }

    public Model createFreshModel() {
        return this.freshModel;
    }

    public Model openModel(String name, boolean strict) {
        if (strict && !this.hasModel(name)) {
            throw new DoesNotExistException(name);
        }
        return this.openModel(name);
    }

    public Model openModelIfPresent(String name) {
        return this.models.get(name);
    }

    public void removeModel(String name) {
        if (!this.hasModel(name)) {
            throw new DoesNotExistException(name);
        }
        this.models.remove(name);
    }

    private static class ModelMakerRigorousStub
    extends ModelMakerStub {
        public ModelMakerRigorousStub(Model defaultModel, Model freshModel) {
            super(defaultModel, freshModel);
        }

        public Model openModel(String name) {
            if (this.hasModel(name)) {
                return (Model)this.models.get(name);
            }
            throw new DoesNotExistException(name);
        }

        public Model getModel(String name) {
            if (this.hasModel(name)) {
                return (Model)this.models.get(name);
            }
            return null;
        }

        public Model getModel(String name, ModelReader loadIfAbsent) {
            if (this.hasModel(name)) {
                return (Model)this.models.get(name);
            }
            throw new CannotCreateException(name);
        }
    }

    private static class ModelMakerRelaxedStub
    extends ModelMakerStub {
        public ModelMakerRelaxedStub(Model defaultModel, Model freshModel) {
            super(defaultModel, freshModel);
        }

        public Model openModel(String name) {
            if (this.hasModel(name)) {
                return (Model)this.models.get(name);
            }
            return this.freshModel;
        }

        public Model getModel(String name) {
            if (this.hasModel(name)) {
                return (Model)this.models.get(name);
            }
            return this.freshModel;
        }

        public Model getModel(String name, ModelReader loadIfAbsent) {
            if (this.hasModel(name)) {
                return (Model)this.models.get(name);
            }
            return this.freshModel;
        }
    }
}

