/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy.bean;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.listener.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBean;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionLevels;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.RoleRestrictedProperty;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyDao;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyRestrictionListener
implements ChangeListener {
    private static final Log log = LogFactory.getLog(PropertyRestrictionListener.class);

    @Override
    public void doDeleted(Object oldObj, EditProcessObject epo) {
        if (oldObj instanceof RoleRestrictedProperty) {
            RoleRestrictedProperty p = (RoleRestrictedProperty)oldObj;
            PropertyDao.FullPropertyKey key = new PropertyDao.FullPropertyKey(p);
            this.updateLevels(new PropertyRestrictionLevels(key, p));
        } else {
            log.warn((Object)("Not an instance of RoleRestrictedProperty: " + oldObj));
        }
    }

    @Override
    public void doInserted(Object newObj, EditProcessObject epo) {
        if (newObj instanceof RoleRestrictedProperty) {
            RoleRestrictedProperty p = (RoleRestrictedProperty)newObj;
            PropertyDao.FullPropertyKey key = new PropertyDao.FullPropertyKey(p);
            this.updateLevels(new PropertyRestrictionLevels(key, p));
        } else {
            log.warn((Object)("Not an instance of RoleRestrictedProperty: " + newObj));
        }
    }

    @Override
    public void doUpdated(Object oldObj, Object newObj, EditProcessObject epo) {
        if (newObj instanceof RoleRestrictedProperty) {
            RoleRestrictedProperty newP = (RoleRestrictedProperty)newObj;
            PropertyDao.FullPropertyKey key = new PropertyDao.FullPropertyKey(newP);
            this.updateLevels(new PropertyRestrictionLevels(key, newP));
        } else {
            log.warn((Object)("Not instances of RoleRestrictedProperty: " + oldObj + ", " + newObj));
        }
    }

    private void updateLevels(PropertyRestrictionLevels levels) {
        PropertyRestrictionBean.getBean().updateProperty(levels);
    }
}

